/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.skype;

import java.util.Date;
import jp.sf.skype.Call;
import jp.sf.skype.CallReceivedListener;
import jp.sf.skype.CommandFailedException;
import jp.sf.skype.Friend;
import jp.sf.skype.Skype;
import jp.sf.skype.TestData;
import jp.sf.skype.TestUtils;
import junit.framework.TestCase;

public class CallAPITest
extends TestCase {
    public void testCallAndFinish() throws Exception {
        TestUtils.showMessageDialog(String.valueOf(TestData.getFriendId()) + "\u306b\u767a\u4fe1\u304c\u884c\u308f\u308c\u30662\u79d2\u5f8c\u306b\u5207\u308c\u308b\u304b\u3069\u3046\u304b\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044");
        Friend friend = Skype.getContactList().getFriend(TestData.getFriendId());
        Call call = friend.call();
        Thread.sleep(2000L);
        call.finish();
        TestUtils.showCheckDialog(String.valueOf(TestData.getFriendId()) + "\u306b\u767a\u4fe1\u304c\u884c\u308f\u308c\u30662\u79d2\u5f8c\u306b\u5207\u308c\u307e\u3057\u305f\u304b\uff1f");
    }

    public void testFinishEndedCall() throws Exception {
        Friend friend = Skype.getContactList().getFriend(TestData.getFriendId());
        Call call = friend.call();
        call.finish();
        Thread.sleep(1000L);
        try {
            call.finish();
        }
        catch (CommandFailedException e) {
            CallAPITest.assertEquals((int)24, (int)e.getCode());
            CallAPITest.assertEquals((String)"Cannot hangup inactive call", (String)e.getMessage());
        }
    }

    public void testHoldAndResume() throws Exception {
        TestUtils.showMessageDialog(String.valueOf(TestData.getFriendId()) + "\u306b\u767a\u4fe1\u304c\u884c\u308f\u308c\u306610\u79d2\u4ee5\u5185\u306b\u4f1a\u8a71\u3092\u958b\u59cb\u3057\u3066\u304f\u3060\u3055\u3044");
        Friend friend = Skype.getContactList().getFriend(TestData.getFriendId());
        Call call = friend.call();
        Thread.sleep(10000L);
        TestUtils.showMessageDialog("5\u79d2\u9593\u901a\u8a71\u304c\u4e2d\u65ad\u3055\u308c\u305f\u5f8c\u306b5\u79d2\u9593\u901a\u8a71\u304c\u518d\u958b\u3055\u308c\u308b\u304b\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044");
        call.hold();
        Thread.sleep(5000L);
        call.resume();
        Thread.sleep(5000L);
        call.finish();
        TestUtils.showCheckDialog("5\u79d2\u9593\u901a\u8a71\u304c\u4e2d\u65ad\u3055\u308c\u305f\u5f8c\u306b5\u79d2\u9593\u901a\u8a71\u304c\u518d\u958b\u3055\u308c\u307e\u3057\u305f\u304b\uff1f");
    }

    public void testCallProperty() throws Exception {
        Date startTime = new Date();
        TestUtils.showMessageDialog(String.valueOf(TestData.getFriendId()) + "\u306b\u767a\u4fe1\u304c\u884c\u308f\u308c\u306610\u79d2\u4ee5\u5185\u306b\u4f1a\u8a71\u3092\u958b\u59cb\u3057\u3066\u304f\u3060\u3055\u3044");
        Friend friend = Skype.getContactList().getFriend(TestData.getFriendId());
        Call call = friend.call();
        Thread.sleep(10000L);
        TestUtils.showMessageDialog("\u81ea\u52d5\u5207\u65ad\u5f8c\u306b\u5404\u7a2e\u30d7\u30ed\u30d1\u30c6\u30a3\u306e\u5024\u304c\u30c6\u30b9\u30c8\u3055\u308c\u307e\u3059");
        call.finish();
        Date endTime = new Date();
        CallAPITest.assertTrue((call.getStartTime().getTime() - startTime.getTime() <= endTime.getTime() - startTime.getTime() ? 1 : 0) != 0);
        CallAPITest.assertTrue(((long)call.getDuration() <= endTime.getTime() - startTime.getTime() ? 1 : 0) != 0);
        CallAPITest.assertEquals((String)TestData.getFriendId(), (String)call.getPartnerId());
        CallAPITest.assertEquals((String)TestData.getFriendDisplayName(), (String)call.getPartnerDisplayName());
    }

    public void testCallReceived() throws Exception {
        final Call[] result = new Call[1];
        Skype.addCallReceivedListener(new CallReceivedListener(){

            public void callReceived(Call call) {
                result[0] = call;
            }
        });
        TestUtils.showMessageDialog("\u81ea\u5206\u306b\u5bfe\u3057\u3066" + TestData.getFriendId() + "\u306b\u767a\u4fe1\u3092\u4f9d\u983c\u3057\u3066\u7740\u4fe1\u3057\u305f\u3089\u30c0\u30a4\u30a2\u30ed\u30b0\u3092\u9589\u3058\u3066\u5207\u65ad\u3057\u3066\u304f\u3060\u3055\u3044");
        CallAPITest.assertEquals((String)TestData.getFriendId(), (String)result[0].getPartnerId());
    }
}

