/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.skype;

import jp.sf.skype.Message;
import jp.sf.skype.SkypeException;
import jp.sf.skype.Utils;
import jp.sf.skype.connector.Connector;
import jp.sf.skype.connector.ConnectorException;

public final class Chat {
    private final String id;

    Chat(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public Message send(String message) throws SkypeException {
        try {
            String responseHeader = "MESSAGE ";
            String response = Connector.getInstance().execute("CHATMESSAGE " + this.getId() + " " + message, responseHeader);
            Utils.checkError(response);
            String id = response.substring(responseHeader.length(), response.indexOf(" STATUS "));
            return new Message(id);
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        DIALOG,
        MULTI_SUBSCRIBED;

    }
}

