/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.skype;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import jp.sf.skype.Call;
import jp.sf.skype.Chat;
import jp.sf.skype.Message;
import jp.sf.skype.Skype;
import jp.sf.skype.SkypeException;
import jp.sf.skype.Utils;
import jp.sf.skype.VoiceMail;

public final class Friend {
    private String id;

    Friend(String id) {
        this.id = id;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object compared) {
        if (this == compared) {
            return true;
        }
        if (compared instanceof Friend) {
            return this.getId().equals(((Friend)compared).getId());
        }
        return false;
    }

    public String toString() {
        return this.getId();
    }

    public String getId() {
        return this.id;
    }

    public String getFullName() throws SkypeException {
        return this.getProperty("FULLNAME");
    }

    public Date getBirthDay() throws SkypeException {
        String value = this.getProperty("BIRTHDAY");
        if ("0".equals(value)) {
            return null;
        }
        try {
            return new SimpleDateFormat("yyyyMMdd").parse(value);
        }
        catch (ParseException e) {
            throw new IllegalStateException("library developer should check Skype specification.");
        }
    }

    public Sex getSex() throws SkypeException {
        return Sex.valueOf(this.getProperty("SEX"));
    }

    public Status getOnlineStatus() throws SkypeException {
        return Status.valueOf(this.getProperty("ONLINESTATUS"));
    }

    public String getLauguage() throws SkypeException {
        return this.getProperty("LANGUAGE");
    }

    public String getCountry() throws SkypeException {
        return this.getProperty("COUNTRY");
    }

    public String getProvince() throws SkypeException {
        return this.getProperty("PROVINCE");
    }

    public String getCity() throws SkypeException {
        return this.getProperty("CITY");
    }

    public String getHomePhone() throws SkypeException {
        return this.getProperty("PHONE_HOME");
    }

    public String getOfficePhone() throws SkypeException {
        return this.getProperty("PHONE_OFFICE");
    }

    public String getMobilePhone() throws SkypeException {
        return this.getProperty("PHONE_MOBILE");
    }

    public String getHomePageAddress() throws SkypeException {
        return this.getProperty("HOMEPAGE");
    }

    public String getAbout() throws SkypeException {
        return this.getProperty("ABOUT");
    }

    public String getDisplayName() throws SkypeException {
        return this.getProperty("DISPLAYNAME");
    }

    public boolean isVideoCapable() {
        return Boolean.parseBoolean("IS_VIDEO_CAPABLE");
    }

    private String getProperty(String name) throws SkypeException {
        return Utils.getProperty("USER", this.getId(), name);
    }

    public Call call() throws SkypeException {
        return Skype.call(this.getId());
    }

    public Chat chat() throws SkypeException {
        return Skype.chat(this.getId());
    }

    public Message send(String message) throws SkypeException {
        return Skype.chat(this.getId()).send(message);
    }

    public VoiceMail leaveVoiceMail() throws SkypeException {
        return Skype.leaveVoiceMail(this.getId());
    }

    public void setDisplayName(String displayName) throws SkypeException {
        Utils.setProperty("USER", this.getId(), "DISPLAYNAME", displayName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        UNKNOWN,
        OFFLINE,
        ONLINE,
        AWAY,
        NA,
        DND,
        SKYPEOUT,
        SKYPEME;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Sex {
        UNKNOWN,
        MALE,
        FEMALE;

    }
}

