/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.skype;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import jp.sf.skype.ContactList;
import jp.sf.skype.Friend;
import jp.sf.skype.Skype;
import jp.sf.skype.TestCaseProperties;
import jp.sf.skype.TestData;
import junit.framework.TestCase;

public final class FriendAPITest
extends TestCase {
    private TestCaseProperties data = new TestCaseProperties(((Object)((Object)this)).getClass());

    public void testGetFriends() throws Exception {
        ContactList list = Skype.getContactList();
        Friend[] friend = list.getAllFriends();
        FriendAPITest.assertTrue((friend.length > 0 ? 1 : 0) != 0);
    }

    public void testGetFriend() throws Exception {
        ContactList list = Skype.getContactList();
        Friend friend = list.getFriend(this.data.getProperty("id"));
        FriendAPITest.assertNotNull((Object)friend);
    }

    public void testFriendProperties() throws Exception {
        Friend friend = Skype.getContactList().getFriend(this.data.getProperty("id"));
        FriendAPITest.assertEquals((String)TestData.getFriendDisplayName(), (String)friend.getFullName());
        try {
            Date expectedBirthDay = new SimpleDateFormat("yyyy/MM/dd").parse(this.data.getProperty("birthDay"));
            FriendAPITest.assertEquals((Object)expectedBirthDay, (Object)friend.getBirthDay());
        }
        catch (ParseException e) {
            FriendAPITest.fail((String)"check FRIEND_BIRTHDAY constant value's format");
        }
        FriendAPITest.assertEquals((String)this.data.getProperty("sex"), (String)("" + (Object)((Object)friend.getSex())));
        FriendAPITest.assertEquals((String)this.data.getProperty("language"), (String)friend.getLauguage());
        FriendAPITest.assertEquals((String)this.data.getProperty("country"), (String)friend.getCountry());
        FriendAPITest.assertEquals((String)this.data.getProperty("province"), (String)friend.getProvince());
        FriendAPITest.assertEquals((String)this.data.getProperty("city"), (String)friend.getCity());
        FriendAPITest.assertEquals((String)this.data.getProperty("homePageAddress"), (String)friend.getHomePageAddress());
        FriendAPITest.assertFalse((String)this.data.getProperty("isVideoCapable"), (boolean)friend.isVideoCapable());
    }
}

