/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.skype;

import jp.sf.skype.Friend;
import jp.sf.skype.Skype;
import jp.sf.skype.SkypeException;
import jp.sf.skype.Utils;
import jp.sf.skype.connector.Connector;
import jp.sf.skype.connector.ConnectorException;

public final class Group {
    private String id;

    Group(String id) {
        this.id = id;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object compared) {
        if (this == compared) {
            return true;
        }
        if (compared instanceof Group) {
            return this.getId().equals(((Group)compared).getId());
        }
        return false;
    }

    public String toString() {
        return this.getId();
    }

    public String getId() {
        return this.id;
    }

    public void addFriend(Friend friend) throws SkypeException {
        Utils.executeWithErrorCheck("ALTER GROUP " + this.getId() + " ADDUSER " + friend.getId());
    }

    public void addPSTN(String pstn) throws SkypeException {
        Utils.executeWithErrorCheck("ALTER GROUP " + this.getId() + " ADDUSER " + pstn);
    }

    public void removeFriend(Friend friend) throws SkypeException {
        Utils.executeWithErrorCheck("ALTER GROUP " + this.getId() + " REMOVEUSER " + friend.getId());
    }

    public void removePSTN(String pstn) throws SkypeException {
        Utils.executeWithErrorCheck("ALTER GROUP " + this.getId() + " REMOVEUSER " + pstn);
    }

    public void changeFriendDisplayName(Friend friend, String displayName) throws SkypeException {
        friend.setDisplayName(displayName);
    }

    public void changePSTNDisplayName(String pstn, String displayName) throws SkypeException {
        Utils.executeWithErrorCheck("SET USER " + pstn + " DISPLAYNAME " + displayName);
    }

    public Friend[] getAllFriends() throws SkypeException {
        String[] ids = Utils.convertToArray(this.getProperty("USERS"));
        Friend[] friends = new Friend[ids.length];
        int i = 0;
        while (i < ids.length) {
            friends[i] = Skype.getContactList().getFriend(ids[i]);
            ++i;
        }
        return friends;
    }

    public boolean hasFriend(Friend checked) throws SkypeException {
        Friend[] friendArray = this.getAllFriends();
        int n = 0;
        int n2 = friendArray.length;
        while (n < n2) {
            Friend friend = friendArray[n];
            if (checked.equals(friend)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean isVisible() throws SkypeException {
        return Boolean.parseBoolean(this.getProperty("VISIBLE"));
    }

    public boolean isExpanded() throws SkypeException {
        return Boolean.parseBoolean(this.getProperty("EXPANDED"));
    }

    public String getDisplayName() throws SkypeException {
        return this.getProperty("DISPLAYNAME");
    }

    public void setDisplayName(String newValue) throws SkypeException {
        this.setProperty("DISPLAYNAME", newValue);
    }

    public Type getType() throws SkypeException {
        return Type.valueOf(this.getProperty("TYPE"));
    }

    private String getProperty(String name) throws SkypeException {
        return Utils.getProperty("GROUP", this.getId(), name);
    }

    private void setProperty(String name, String newValue) throws SkypeException {
        Utils.setProperty("GROUP", this.getId(), name, newValue);
    }

    public void dispose() throws SkypeException {
        try {
            String response = Connector.getInstance().execute("DELETE GROUP " + this.getId(), "DELETED GROUP ");
            Utils.checkError(response);
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        ALL_USERS,
        ALL_FRIENDS,
        SKYPE_FRIENDS,
        SKYPEOUT_FRIENDS,
        ONLINE_FRIENDS,
        UNKNOWN_OR_PENDINGAUTH_FRIENDS,
        RECENTLY_CONTACTED_USERS,
        USERS_WAITING_MY_AUTHORIZATION,
        USERS_AUTHORIZED_BY_ME,
        USERS_BLOCKED_BY_ME,
        UNGROUPED_FRIENDS,
        CUSTOM_GROUP;

    }
}

