/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.skype;

import java.util.Date;
import jp.sf.skype.SkypeException;
import jp.sf.skype.Utils;

public final class Message {
    private final String id;

    Message(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public Date getStartTime() throws SkypeException {
        return new Date(Long.parseLong(this.getProperty("TIMESTAMP")));
    }

    public String getPartnerId() throws SkypeException {
        return this.getProperty("PARTNER_HANDLE");
    }

    public String getPartnerDisplayName() throws SkypeException {
        return this.getProperty("PARTNER_DISPNAME");
    }

    public Type getType() throws SkypeException {
        return Type.valueOf(this.getProperty("TYPE"));
    }

    public Type getStatus() throws SkypeException {
        return Type.valueOf(this.getProperty("STATUS"));
    }

    public int getFailureReasonCode() throws SkypeException {
        return Integer.parseInt(this.getProperty("FAILUREREASON"));
    }

    public String getMessage() throws SkypeException {
        return this.getProperty("BODY");
    }

    private String getProperty(String name) throws SkypeException {
        return Utils.getProperty("MESSAGE", this.getId(), name);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        AUTHREQUEST,
        TEXT,
        CONTACTS,
        UNKNOWN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        SENDING,
        SENT,
        FAILED,
        RECEIVED,
        READ,
        IGNORED,
        QUEUED;

    }
}

