/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.skype;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import jp.sf.skype.Friend;
import jp.sf.skype.SkypeException;
import jp.sf.skype.Utils;

public final class Profile {
    Profile() {
    }

    public String getId() throws SkypeException {
        return Utils.getProperty("CURRENTUSERHANDLE");
    }

    public Status getStatus() throws SkypeException {
        return Status.valueOf(Utils.getProperty("USERSTATUS"));
    }

    public void setStatus(Status status) throws SkypeException {
        Utils.setProperty("USERSTATUS", status.toString());
    }

    public boolean canDoSkypeOut() throws SkypeException {
        return this.canDo("SKYPEOUT");
    }

    public boolean canDoSkypeIn() throws SkypeException {
        return this.canDo("SKYPEIN");
    }

    public boolean canDoVoiceMail() throws SkypeException {
        return this.canDo("VOICEMAIL");
    }

    private boolean canDo(String name) throws SkypeException {
        return Boolean.parseBoolean(Utils.getProperty("PRIVILEGE", name));
    }

    public int getPSTNBalance() throws SkypeException {
        return Integer.parseInt(this.getProfileProperty("PSTN_BALANCE"));
    }

    public String getPSTNBalanceCurrencyUnit() throws SkypeException {
        return this.getProfileProperty("PSTN_BALANCE_CURRENCY");
    }

    public String getFullName() throws SkypeException {
        return this.getProfileProperty("FULLNAME");
    }

    public void setFullName(String newValue) throws SkypeException {
        this.setProfileProperty("FULLNAME", newValue);
    }

    public Date getBirthDay() throws SkypeException {
        String value = this.getProfileProperty("BIRTHDAY");
        if ("0".equals(value)) {
            return null;
        }
        try {
            return new SimpleDateFormat("yyyyMMdd").parse(value);
        }
        catch (ParseException e) {
            throw new IllegalStateException("library developer should check Skype specification.");
        }
    }

    public void setBirthDay(Date newValue) throws SkypeException {
        String newValueString = newValue == null ? "0" : new SimpleDateFormat("yyyyMMdd").format(newValue);
        this.setProfileProperty("BIRTHDAY", newValueString);
    }

    public Sex getSex() throws SkypeException {
        return Sex.valueOf(this.getProfileProperty("SEX"));
    }

    public void setSex(Sex newValue) throws SkypeException {
        this.setProfileProperty("SEX", newValue.toString());
    }

    public String[] getAllLauguages() throws SkypeException {
        return this.getProfileProperty("LANGUAGES").split(" ");
    }

    public void setAllLanguages(String[] newValues) throws SkypeException {
        if (newValues == null) {
            newValues = new String[]{};
        }
        this.setProfileProperty("LANGUAGES", this.toSpaceSeparatedString(newValues));
    }

    private String toSpaceSeparatedString(Object[] newValues) {
        StringBuilder newValuesString = new StringBuilder();
        Object[] objectArray = newValues;
        int n = 0;
        int n2 = objectArray.length;
        while (n < n2) {
            Object newValue = objectArray[n];
            newValuesString.append(newValue);
            ++n;
        }
        return newValuesString.toString();
    }

    public void setCountryByISOCode(String newValue) throws SkypeException {
        if (newValue == null) {
            newValue = "";
        }
        this.setProfileProperty("COUNTRY", String.valueOf(newValue) + " " + this.getCountry());
    }

    public void setCountry(String newValue) throws SkypeException {
        if (newValue == null) {
            newValue = "";
        }
        this.setProfileProperty("COUNTRY", String.valueOf(this.getCountryByISOCode()) + " " + newValue);
    }

    public String getCountryByISOCode() throws SkypeException {
        String value = this.getProfileProperty("COUNTRY");
        return value.substring(0, value.indexOf(32));
    }

    public String getCountry() throws SkypeException {
        String value = this.getProfileProperty("COUNTRY");
        return value.substring(value.indexOf(32) + 1);
    }

    public String getProvince() throws SkypeException {
        return this.getProfileProperty("PROVINCE");
    }

    public void setProvince(String newValue) throws SkypeException {
        this.setProfileProperty("PROVINCE", newValue);
    }

    public String getCity() throws SkypeException {
        return this.getProfileProperty("CITY");
    }

    public void setCity(String newValue) throws SkypeException {
        this.setProfileProperty("CITY", newValue);
    }

    public String getHomePhoneNumber() throws SkypeException {
        return this.getProfileProperty("PHONE_HOME");
    }

    public void setHomePhoneNumber(String newValue) throws SkypeException {
        this.setProfileProperty("PHONE_HOME", newValue);
    }

    public String getOfficePhoneNumber() throws SkypeException {
        return this.getProfileProperty("PHONE_OFFICE");
    }

    public void setOfficePhoneNumber(String newValue) throws SkypeException {
        this.setProfileProperty("PHONE_OFFICE", newValue);
    }

    public String getMobilePhoneNumber() throws SkypeException {
        return this.getProfileProperty("PHONE_MOBILE");
    }

    public void setMobilePhoneNumber(String newValue) throws SkypeException {
        this.setProfileProperty("PHONE_MOBILE", newValue);
    }

    public String getHomePageAddress() throws SkypeException {
        return this.getProfileProperty("HOMEPAGE");
    }

    public void setHomePageAddress(String newValue) throws SkypeException {
        this.setProfileProperty("HOMEPAGE", newValue);
    }

    public String getIntroduction() throws SkypeException {
        return this.getProfileProperty("ABOUT");
    }

    public void setIntroduction(String newValue) throws SkypeException {
        this.setProfileProperty("ABOUT", newValue);
    }

    public String getMoodMessage() throws SkypeException {
        return this.getProfileProperty("MOOD_TEXT");
    }

    public void setMoodMessage(String newValue) throws SkypeException {
        this.setProfileProperty("MOOD_TEXT", newValue);
    }

    public int getTimeZone() throws SkypeException {
        return Integer.parseInt(this.getProfileProperty("TIMEZONE"));
    }

    public void setTimeZone(int newValue) throws SkypeException {
        this.setProfileProperty("TIMEZONE", "" + newValue);
    }

    public String getDisplayName() throws SkypeException {
        return this.getProfileProperty("DISPLAYNAME");
    }

    public void setDisplayName(String newValue) throws SkypeException {
        this.setProfileProperty("DISPLAYNAME", newValue);
    }

    public boolean isVideoCapable() throws SkypeException {
        return Boolean.parseBoolean(this.getProfileProperty("IS_VIDEO_CAPABLE"));
    }

    public int getWaitTimeBeforeCallForwarding() throws SkypeException {
        return Integer.parseInt(this.getProfileProperty("CALL_NOANSWER_TIMEOUT"));
    }

    public void setWaitTimeBeforeCallForwarding(int second) throws SkypeException {
        this.setProfileProperty("CALL_NOANSWER_TIMEOUT", "" + second);
    }

    public CallForwardingAction getCallForwardingAction() throws SkypeException {
        return CallForwardingAction.valueOf(this.getProfileProperty("CALL_NOANSWER_ACTION"));
    }

    public void setCallForwardingAction(CallForwardingAction newValue) throws SkypeException {
        this.setProfileProperty("CALL_NOANSWER_ACTION", newValue.toString());
    }

    public CallForwardingRule[] getAllCallForwardingRules() throws SkypeException {
        ArrayList<CallForwardingRule> rules = new ArrayList<CallForwardingRule>();
        String[] stringArray = this.getProfileProperty("CALL_FORWARD_RULES").split(" ");
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String rule = stringArray[n];
            String[] elements = rule.split(",");
            rules.add(new CallForwardingRule(Integer.parseInt(elements[0]), Integer.parseInt(elements[1]), elements[2]));
            ++n;
        }
        return rules.toArray(new CallForwardingRule[0]);
    }

    public void setAllCallForwardingRules(CallForwardingRule[] newValues) throws SkypeException {
        this.setProfileProperty("CALL_FORWARD_RULES", this.toSpaceSeparatedString(newValues));
    }

    private String getProfileProperty(String name) throws SkypeException {
        return Utils.getProperty("PROFILE", name);
    }

    private void setProfileProperty(String name, String value) throws SkypeException {
        Utils.setProperty("PROFILE", name, value);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        UNKNOWN,
        ONLINE,
        OFFLINE,
        SKYPEME,
        AWAY,
        NA,
        DND,
        INVISIBLE,
        LOGGEDOUT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Sex {
        UNKNOWN,
        MALE,
        FEMALE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CallForwardingAction {
        REJECT,
        FORWARD,
        VOICEMAIL;

    }

    public final class CallForwardingRule {
        private final int startSecond;
        private final int endSecond;
        private final String target;

        public CallForwardingRule(int startSecond, int endSecond, String target) {
            this.startSecond = startSecond;
            this.endSecond = endSecond;
            this.target = target;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public boolean equals(Object compared) {
            if (this == compared) {
                return true;
            }
            if (compared instanceof Friend) {
                return this.toString().equals(((Friend)compared).getId());
            }
            return false;
        }

        public String toString() {
            return String.valueOf(this.startSecond) + "," + this.endSecond + "," + this.target;
        }

        public int getEndSecond() {
            return this.endSecond;
        }

        public int getStartSecond() {
            return this.startSecond;
        }

        public String getTarget() {
            return this.target;
        }
    }
}

