/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.skype;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import jp.sf.skype.Application;
import jp.sf.skype.Call;
import jp.sf.skype.CallReceivedListener;
import jp.sf.skype.Chat;
import jp.sf.skype.ContactList;
import jp.sf.skype.Message;
import jp.sf.skype.MessageReceivedListener;
import jp.sf.skype.Profile;
import jp.sf.skype.SkypeException;
import jp.sf.skype.Utils;
import jp.sf.skype.VoiceMail;
import jp.sf.skype.connector.Connector;
import jp.sf.skype.connector.ConnectorException;
import jp.sf.skype.connector.ConnectorListener;
import jp.sf.skype.connector.MessageProcessor;

public final class Skype {
    private static ContactList contactList;
    private static Profile profile;
    private static ConnectorListener messageListener;
    private static List<MessageReceivedListener> messageReceivedListeners;
    private static ConnectorListener callListener;
    private static List<CallReceivedListener> callReceivedListeners;

    static {
        messageReceivedListeners = new ArrayList<MessageReceivedListener>();
        callReceivedListeners = new ArrayList<CallReceivedListener>();
    }

    public static void setDebug(boolean on) throws SkypeException {
        try {
            Connector.getInstance().setDebug(on);
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
        }
    }

    public static String getVersion() throws SkypeException {
        return Utils.getProperty("SKYPEVERSION");
    }

    public static boolean isRunning() throws SkypeException {
        try {
            return Connector.getInstance().isRunning();
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
            return false;
        }
    }

    public static void showSkypeWindow() throws SkypeException {
        Utils.executeWithErrorCheck("FOCUS");
    }

    public static void hideSkypeWindow() throws SkypeException {
        Utils.executeWithErrorCheck("MINIMIZE");
    }

    public static void showAddFriendWindow() throws SkypeException {
        Utils.executeWithErrorCheck("OPEN ADDAFRIEND");
    }

    public static void showAddFriendWindow(String skypeId) throws SkypeException {
        Utils.checkNotNull("skypeId", skypeId);
        Utils.executeWithErrorCheck("OPEN ADDAFRIEND " + skypeId);
    }

    public static void showChatWindow(String skypeId) throws SkypeException {
        Utils.checkNotNull("skypeId", skypeId);
        Utils.executeWithErrorCheck("OPEN IM " + skypeId);
    }

    public static void showChatWindow(String skypeId, String message) throws SkypeException {
        Utils.checkNotNull("skypeId", skypeId);
        Utils.checkNotNull("message", message);
        Utils.executeWithErrorCheck("OPEN IM " + skypeId + " " + message);
    }

    public static void showFileTransferWindow(String skypeId) throws SkypeException {
        Utils.checkNotNull("skypeId", skypeId);
        Utils.executeWithErrorCheck("OPEN FILETRANSFER " + skypeId);
    }

    public static void showFileTransferWindow(String skypeId, File folder) throws SkypeException {
        Utils.checkNotNull("skypeId", skypeId);
        Utils.checkNotNull("folder", folder);
        Utils.executeWithErrorCheck("OPEN FILETRANSFER " + skypeId + " IN " + folder);
    }

    public static void showFileTransferWindow(String[] skypeIds) throws SkypeException {
        Utils.checkNotNull("skypeIds", skypeIds);
        Utils.executeWithErrorCheck("OPEN FILETRANSFER " + Skype.toCommaSeparatedString(skypeIds));
    }

    public static void showFileTransferWindow(String[] skypeIds, File folder) throws SkypeException {
        Utils.checkNotNull("skypeIds", skypeIds);
        Utils.checkNotNull("folder", folder);
        Utils.executeWithErrorCheck("OPEN FILETRANSFER " + Skype.toCommaSeparatedString(skypeIds) + " IN " + folder);
    }

    public static void showProfileWindow() throws SkypeException {
        Utils.executeWithErrorCheck("OPEN PROFILE");
    }

    public static void showUserInformationWindow(String skypeId) throws SkypeException {
        Utils.checkNotNull("skypeId", skypeId);
        Utils.executeWithErrorCheck("OPEN USERINFO " + skypeId);
    }

    public static void showConferenceWindow() throws SkypeException {
        Utils.executeWithErrorCheck("OPEN CONFERENCE");
    }

    public static void showSearchWindow() throws SkypeException {
        Utils.executeWithErrorCheck("OPEN SEARCH");
    }

    public static void showOptionsWindow(OptionsPage page) throws SkypeException {
        Utils.executeWithErrorCheck("OPEN OPTIONS " + page.toString().toLowerCase());
    }

    public static void showCallHistoryTab() throws SkypeException {
        Utils.executeWithErrorCheck("OPEN CALLHISTORY");
    }

    public static void showContactsTab() throws SkypeException {
        Utils.executeWithErrorCheck("OPEN CONTACTS");
    }

    public static void showDialPadTab() throws SkypeException {
        Utils.executeWithErrorCheck("OPEN DIALPAD");
    }

    public static void showSendContactsWindow() throws SkypeException {
        Utils.executeWithErrorCheck("OPEN SENDCONTACTS");
    }

    public static void showBlockedUsersWindow() throws SkypeException {
        Utils.executeWithErrorCheck("OPEN BLOCKEDUSERS");
    }

    public static void showImportContactsWindow() throws SkypeException {
        Utils.executeWithErrorCheck("OPEN IMPORTCONTACTS");
    }

    public static void showGettingStartedWindow() throws SkypeException {
        Utils.executeWithErrorCheck("OPEN GETTINGSTARTED");
    }

    public static void showRequestAuthorizationWindow(String skypeId) throws SkypeException {
        Utils.executeWithErrorCheck("OPEN AUTHORIZATION " + skypeId);
    }

    public static void pressButton(Button button) throws SkypeException {
        Utils.executeWithErrorCheck("BTN_PRESSED " + button.getKey());
    }

    public static void releaseButton(Button button) throws SkypeException {
        Utils.executeWithErrorCheck("BTN_RELEASED " + button.getKey());
    }

    public static ContactList getContactList() throws SkypeException {
        if (contactList == null) {
            contactList = new ContactList();
        }
        return contactList;
    }

    public static Call call(String[] skypeIds) throws SkypeException {
        Utils.checkNotNull("skypeIds", skypeIds);
        return Skype.call(Skype.toCommaSeparatedString(skypeIds));
    }

    public static Call call(String skypeId) throws SkypeException {
        Utils.checkNotNull("skypeIds", skypeId);
        try {
            final Call[] call = new Call[1];
            final String[] error = new String[1];
            MessageProcessor processor = new MessageProcessor(){

                public void messageReceived(String message) {
                    if (message.startsWith("CALL ")) {
                        String response = message.substring("CALL ".length());
                        String id = response.substring(0, response.indexOf(32));
                        if (call[0] == null) {
                            call[0] = new Call(id);
                        }
                        if (call[0].getId().equals(id)) {
                            this.processStatus(response.substring(id.length() + 1));
                            this.releaseLock();
                        }
                    } else if (message.startsWith("ERROR ") && call[0] == null) {
                        error[0] = message.substring("ERROR ".length());
                        this.releaseLock();
                    }
                }

                private void processStatus(String response) {
                    if (response.startsWith("STATUS ")) {
                        Call.Status[] endStatusList;
                        Call.Status status = Call.Status.valueOf(response.substring("STATUS ".length()));
                        Call.Status[] statusArray = endStatusList = new Call.Status[]{Call.Status.FAILED, Call.Status.FINISHED, Call.Status.MISSED, Call.Status.REFUSED, Call.Status.BUSY, Call.Status.CANCELLED};
                        int n = 0;
                        int n2 = statusArray.length;
                        while (n < n2) {
                            Call.Status endStatus = statusArray[n];
                            if (status == endStatus) {
                                this.processedAllMessages();
                            }
                            ++n;
                        }
                    }
                }
            };
            Connector.getInstance().execute("CALL " + skypeId, processor);
            Utils.checkError(error[0]);
            return call[0];
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
            return null;
        }
    }

    public static Chat chat(String target) throws SkypeException {
        try {
            String responseHeader = "CHAT ";
            String response = Connector.getInstance().execute("CHAT CREATE " + target, responseHeader);
            Utils.checkError(response);
            String id = response.substring(responseHeader.length(), response.indexOf(" STATUS "));
            return new Chat(id);
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
            return null;
        }
    }

    public static VoiceMail leaveVoiceMail(String target) throws SkypeException {
        try {
            String responseHeader = "VOICEMAIL ";
            String response = Connector.getInstance().execute("VOICEMAIL " + target, responseHeader);
            Utils.checkError(response);
            String id = response.substring(responseHeader.length(), response.indexOf(32, responseHeader.length()));
            return new VoiceMail(id);
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
            return null;
        }
    }

    public static Application addApplication(String name) throws SkypeException {
        Application application = new Application(name);
        application.initalize();
        return application;
    }

    public static String getVideoDevice() throws SkypeException {
        try {
            String responseHeader = "VIDEO_IN ";
            String response = Connector.getInstance().execute("GET VIDEO_IN", responseHeader);
            Utils.checkError(response);
            String name = response.substring(responseHeader.length());
            if (!Skype.isDefaultVideoDevice(name)) {
                return name;
            }
            return null;
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
            return null;
        }
    }

    public static void setVideoDevice(String name) throws SkypeException {
        try {
            if (Skype.isDefaultVideoDevice(name)) {
                name = "";
            }
            String responseHeader = "VIDEO_IN ";
            String response = Connector.getInstance().execute("SET VIDEO_IN " + name, responseHeader);
            Utils.checkError(response);
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
        }
    }

    private static boolean isDefaultVideoDevice(String name) {
        return name == null || "".equals(name);
    }

    public static void openVideoTestWindow() throws SkypeException {
        Utils.executeWithErrorCheck("OPEN VIDEOTEST");
    }

    public static void openVideoOptionsWindow() throws SkypeException {
        Utils.executeWithErrorCheck("OPEN OPTIONS VIDEO");
    }

    private Skype() {
    }

    public static synchronized Profile getProfile() {
        if (profile == null) {
            profile = new Profile();
        }
        return profile;
    }

    public static void addMessageReceivedListener(MessageReceivedListener listener) throws SkypeException {
        Utils.checkNotNull("listener", listener);
        messageReceivedListeners.add(listener);
        try {
            if (messageListener == null) {
                messageListener = new ConnectorListener(){

                    public void messageReceived(String message) {
                        if (message.startsWith("MESSAGE ")) {
                            String data = message.substring("MESSAGE ".length());
                            String id = data.substring(0, data.indexOf(32));
                            if (message.endsWith(" STATUS RECEIVED")) {
                                Skype.fireMessageReceived(new Message(id));
                            }
                        }
                    }
                };
                Connector.getInstance().addConnectorListener(messageListener);
            }
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
        }
    }

    public static void removeMessageReceivedListener(MessageReceivedListener listener) {
        Utils.checkNotNull("listener", listener);
        messageReceivedListeners.remove(listener);
        if (!messageReceivedListeners.isEmpty()) {
            Connector.getInstance().removeConnectorListener(messageListener);
            messageListener = null;
        }
    }

    private static void fireMessageReceived(Message message) {
        MessageReceivedListener[] listeners;
        assert (message != null);
        MessageReceivedListener[] messageReceivedListenerArray = listeners = messageReceivedListeners.toArray(new MessageReceivedListener[0]);
        int n = 0;
        int n2 = messageReceivedListenerArray.length;
        while (n < n2) {
            MessageReceivedListener listener = messageReceivedListenerArray[n];
            listener.messageReceived(message);
            ++n;
        }
    }

    public static void addCallReceivedListener(CallReceivedListener listener) throws SkypeException {
        Utils.checkNotNull("listener", listener);
        callReceivedListeners.add(listener);
        try {
            if (callListener == null) {
                callListener = new ConnectorListener(){

                    public void messageReceived(String call) {
                        if (call.startsWith("CALL ")) {
                            String data = call.substring("CALL ".length());
                            String id = data.substring(0, data.indexOf(32));
                            if (call.endsWith(" STATUS RINGING")) {
                                Skype.fireCallReceived(new Call(id));
                            }
                        }
                    }
                };
                Connector.getInstance().addConnectorListener(callListener);
            }
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
        }
    }

    public static void removeCallReceivedListener(CallReceivedListener listener) {
        Utils.checkNotNull("listener", listener);
        callReceivedListeners.remove(listener);
        if (!callReceivedListeners.isEmpty()) {
            Connector.getInstance().removeConnectorListener(callListener);
            callListener = null;
        }
    }

    private static void fireCallReceived(Call call) {
        CallReceivedListener[] listeners;
        assert (call != null);
        CallReceivedListener[] callReceivedListenerArray = listeners = callReceivedListeners.toArray(new CallReceivedListener[0]);
        int n = 0;
        int n2 = callReceivedListenerArray.length;
        while (n < n2) {
            CallReceivedListener listener = callReceivedListenerArray[n];
            listener.callReceived(call);
            ++n;
        }
    }

    private static String toCommaSeparatedString(String[] array) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < array.length) {
            if (i != 0) {
                builder.append(", ");
            }
            builder.append(array[i]);
            ++i;
        }
        return builder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OptionsPage {
        GENERAL,
        PRIVACY,
        NOTIFICATIONS,
        SOUNDALERTS,
        SOUNDDEVICES,
        HOTKEYS,
        CONNECTION,
        VOICEMAIL,
        CALLFORWARD,
        VIDEO,
        ADVANCED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Button {
        KEY_0,
        KEY_1,
        KEY_2,
        KEY_3,
        KEY_4,
        KEY_5,
        KEY_6,
        KEY_7,
        KEY_8,
        KEY_9,
        KEY_A,
        KEY_B,
        KEY_C,
        KEY_D,
        KEY_E,
        KEY_F,
        KEY_G,
        KEY_H,
        KEY_I,
        KEY_J,
        KEY_K,
        KEY_L,
        KEY_M,
        KEY_N,
        KEY_O,
        KEY_P,
        KEY_Q,
        KEY_R,
        KEY_S,
        KEY_T,
        KEY_U,
        KEY_V,
        KEY_W,
        KEY_X,
        KEY_Y,
        KEY_Z,
        KEY_SHARP("#"),
        KEY_ASTERISK("*"),
        KEY_PLUS("+"),
        KEY_UP,
        KEY_DOWN,
        KEY_YES,
        KEY_NO,
        KEY_PAGEUP,
        KEY_PAGEDOWN,
        KEY_SKYPE;

        private String key;

        private Button() {
        }

        private Button(String key) {
            this.key = key;
        }

        private String getKey() {
            if (this.key != null) {
                return this.key;
            }
            return this.name().substring(this.name().indexOf(95) + 1);
        }
    }
}

