/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.skype;

import java.util.ArrayList;
import java.util.List;
import jp.sf.skype.Application;
import jp.sf.skype.Friend;
import jp.sf.skype.SkypeException;
import jp.sf.skype.StreamListener;
import jp.sf.skype.Utils;
import jp.sf.skype.connector.Connector;
import jp.sf.skype.connector.ConnectorException;
import jp.sf.skype.connector.MessageProcessor;

public final class Stream {
    private final Application application;
    private final Friend friend;
    private final int number;
    private List<StreamListener> listeners = new ArrayList<StreamListener>();

    Stream(Application application, Friend friend, int number) {
        assert (application != null);
        assert (friend != null);
        this.application = application;
        this.friend = friend;
        this.number = number;
    }

    public Application getApplication() {
        return this.application;
    }

    public Friend getFriend() {
        return this.friend;
    }

    public int getNumber() {
        return this.number;
    }

    public String getId() {
        return String.valueOf(this.getFriend().getId()) + ":" + this.getNumber();
    }

    public void write(String text) throws SkypeException {
        Utils.checkNotNull(text, "text");
        try {
            final String[] error = new String[1];
            MessageProcessor processor = new MessageProcessor(){

                public void messageReceived(String message) {
                    if (!message.startsWith("APPLICATION " + Stream.this.getApplication().getName() + " SENDING " + Stream.this.getId())) {
                        if (message.equals("APPLICATION " + Stream.this.getApplication().getName() + " SENDING ")) {
                            this.releaseLock();
                        } else if (message.startsWith("ERROR ")) {
                            error[0] = message.substring("ERROR ".length());
                            this.releaseLock();
                        }
                    }
                }
            };
            Connector.getInstance().execute("ALTER APPLICATION " + this.getApplication().getName() + " WRITE " + this.getId() + " " + text, processor);
            Utils.checkError(error[0]);
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
        }
    }

    public void send(String datagram) throws SkypeException {
        Utils.checkNotNull(datagram, "datagram");
        try {
            final String[] error = new String[1];
            MessageProcessor processor = new MessageProcessor(){

                public void messageReceived(String message) {
                    if (!message.startsWith("APPLICATION " + Stream.this.getApplication().getName() + " SENDING " + Stream.this.getId())) {
                        if (message.equals("APPLICATION " + Stream.this.getApplication().getName() + " SENDING ")) {
                            this.releaseLock();
                        } else if (message.startsWith("ERROR ")) {
                            error[0] = message.substring("ERROR ".length());
                            this.releaseLock();
                        }
                    }
                }
            };
            Connector.getInstance().execute("ALTER APPLICATION " + this.getApplication().getName() + " DATAGRAM " + this.getId() + " " + datagram, processor);
            Utils.checkError(error[0]);
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
        }
    }

    public void addCommunicationListener(StreamListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener is null");
        }
        this.listeners.add(listener);
    }

    public void removeCommunicationListener(StreamListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener is null");
        }
        this.listeners.remove(listener);
    }

    void fireTextReceived(String text) {
        StreamListener[] listeners;
        assert (text != null);
        StreamListener[] streamListenerArray = listeners = this.listeners.toArray(new StreamListener[0]);
        int n = 0;
        int n2 = streamListenerArray.length;
        while (n < n2) {
            StreamListener listener = streamListenerArray[n];
            listener.textReceived(text);
            ++n;
        }
    }

    void fireDatagramReceived(String datagram) {
        StreamListener[] listeners;
        assert (datagram != null);
        StreamListener[] streamListenerArray = listeners = this.listeners.toArray(new StreamListener[0]);
        int n = 0;
        int n2 = streamListenerArray.length;
        while (n < n2) {
            StreamListener listener = streamListenerArray[n];
            listener.datagramReceived(datagram);
            ++n;
        }
    }

    public void disconnect() throws SkypeException {
        try {
            String response = Connector.getInstance().execute("ALTER APPLICATION " + this.application.getName() + " DISCONNECT " + this.friend.getId() + ":1");
            Utils.checkError(response);
            this.application.fireDisconnected(this);
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
        }
    }
}

