/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.skype;

import jp.sf.skype.CommandFailedException;
import jp.sf.skype.NotAttachedException;
import jp.sf.skype.SkypeException;
import jp.sf.skype.connector.Connector;
import jp.sf.skype.connector.ConnectorException;
import jp.sf.skype.connector.TimeOutException;

final class Utils {
    /*
     * WARNING - void declaration
     */
    static void convertToSkypeException(ConnectorException e) throws SkypeException {
        void var1_1;
        SkypeException r;
        if (e instanceof jp.sf.skype.connector.NotAttachedException) {
            r = new NotAttachedException();
        } else if (e instanceof TimeOutException) {
            r = new jp.sf.skype.TimeOutException(e.getMessage());
        } else {
            throw new IllegalStateException("can't convert connector exception to skype exception");
        }
        var1_1.initCause(e);
        throw var1_1;
    }

    static void checkError(String response) throws SkypeException {
        if (response == null) {
            return;
        }
        if (response.startsWith("ERROR ")) {
            throw new CommandFailedException(response);
        }
    }

    static String getProperty(String type, String id, String name) throws SkypeException {
        try {
            String command = "GET " + type + " " + id + " " + name;
            String responseHeader = String.valueOf(type) + " " + id + " " + name + " ";
            String response = Connector.getInstance().execute(command, responseHeader);
            Utils.checkError(response);
            return response.substring(responseHeader.length());
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
            return null;
        }
    }

    static String getProperty(String type, String name) throws SkypeException {
        try {
            String command = "GET " + type + " " + name;
            String responseHeader = String.valueOf(type) + " " + name + " ";
            String response = Connector.getInstance().execute(command, responseHeader);
            Utils.checkError(response);
            return response.substring(responseHeader.length());
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
            return null;
        }
    }

    static String getProperty(String name) throws SkypeException {
        try {
            String command = "GET " + name + " ";
            String responseHeader = String.valueOf(name) + " ";
            String response = Connector.getInstance().execute(command, responseHeader);
            Utils.checkError(response);
            return response.substring(responseHeader.length());
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
            return null;
        }
    }

    static void setProperty(String type, String id, String name, String value) throws SkypeException {
        try {
            String command = "SET " + type + " " + id + " " + name + " " + value;
            String responseHeader = String.valueOf(type) + " " + id + " " + name + " " + value;
            String response = Connector.getInstance().execute(command, responseHeader);
            Utils.checkError(response);
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
        }
    }

    static void setProperty(String type, String name, String value) throws SkypeException {
        try {
            String command = "SET " + type + " " + name + " " + value;
            String responseHeader = String.valueOf(type) + " " + name + " " + value;
            String response = Connector.getInstance().execute(command, responseHeader);
            Utils.checkError(response);
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
        }
    }

    static void setProperty(String name, String value) throws SkypeException {
        try {
            String command = "SET " + name + " " + value;
            String responseHeader = String.valueOf(name) + " " + value;
            String response = Connector.getInstance().execute(command, responseHeader);
            Utils.checkError(response);
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
        }
    }

    static void executeWithErrorCheck(String command) throws SkypeException {
        try {
            String response = Connector.getInstance().execute(command);
            Utils.checkError(response);
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
        }
    }

    static void checkNotNull(String name, Object value) {
        if (value == null) {
            throw new IllegalArgumentException(String.valueOf(name) + " is null");
        }
    }

    static String[] convertToArray(String listString) {
        String[] array = listString.split(",");
        int i = 0;
        int length = array.length;
        while (i < length) {
            array[i] = array[i].trim();
            ++i;
        }
        return array;
    }

    private Utils() {
    }
}

