/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.skype.connector;

import java.util.ArrayList;
import java.util.List;
import jp.sf.skype.connector.ConnectorException;
import jp.sf.skype.connector.ConnectorListener;
import jp.sf.skype.connector.MessageProcessor;
import jp.sf.skype.connector.NotAttachedException;
import jp.sf.skype.connector.TimeOutException;
import jp.sf.skype.connector.Utils;
import jp.sf.skype.connector.win32.Win32Connector;

public abstract class Connector {
    private static Connector instance;
    private List<ConnectorListener> listeners = new ArrayList<ConnectorListener>();
    private int commandResponseTime = 10000;
    private int commandCount;
    private boolean debug = false;
    private ConnectorListener debugListener;

    public static synchronized Connector getInstance() {
        if (instance == null) {
            instance = new Win32Connector();
        }
        return instance;
    }

    protected Connector() {
    }

    public final void setDebug(boolean on) throws ConnectorException {
        this.debug = on;
        if (this.debug) {
            this.debugListener = new ConnectorListener(){

                public void messageReceived(String message) {
                    System.out.println("<- " + message);
                }
            };
            this.addConnectorListener(this.debugListener);
        } else {
            this.removeConnectorListener(this.debugListener);
            this.debugListener = null;
        }
    }

    private boolean isDebug() {
        return this.debug;
    }

    public final void setCommandResposeTime(int newValue) {
        this.commandResponseTime = newValue;
    }

    public final int getCommandResponseTime() {
        return this.commandResponseTime;
    }

    protected abstract Status connect(int var1) throws ConnectorException;

    public abstract Status getStatus();

    protected abstract void sendCommand(String var1);

    public final boolean isRunning() throws ConnectorException {
        return this.connect(this.getCommandResponseTime()) != Status.NOT_RUNNING;
    }

    public final Status connect() throws ConnectorException {
        return this.connect(60000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute(String command, final MessageProcessor processor) throws ConnectorException {
        this.assureAttached();
        Object lock = new Object();
        ConnectorListener listener = new ConnectorListener(){

            public void messageReceived(String message) {
                processor.messageReceived(message);
            }
        };
        processor.init(lock, listener);
        this.addConnectorListener(listener, false);
        Object object = lock;
        synchronized (object) {
            if (this.isDebug()) {
                System.out.println("-> " + command);
            }
            this.sendCommand(command);
            try {
                try {
                    lock.wait(this.getCommandResponseTime());
                }
                catch (InterruptedException e) {
                    throw new TimeOutException("'" + command + "' is not executed");
                }
            }
            finally {
                this.removeConnectorListener(listener);
            }
        }
    }

    public final String execute(String command) throws ConnectorException {
        return this.execute(command, command);
    }

    public final String executeWithId(String command, String responseHeader) throws ConnectorException {
        String header = "#" + this.commandCount++ + " ";
        String response = this.execute(String.valueOf(header) + command, new String[]{String.valueOf(header) + responseHeader, String.valueOf(header) + "ERROR "}, true);
        return response.substring(header.length());
    }

    public final String execute(String command, String responseHeader) throws ConnectorException {
        return this.execute(command, new String[]{responseHeader, "ERROR "}, true);
    }

    private String execute(String command, String responseHeader, boolean checkAttached) throws ConnectorException {
        return this.execute(command, new String[]{responseHeader}, checkAttached);
    }

    public final String execute(String command, String[] responseHeaders) throws ConnectorException {
        return this.execute(command, responseHeaders, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String execute(String command, final String[] responseHeaders, boolean checkAttached) throws ConnectorException {
        if (checkAttached) {
            this.assureAttached();
        }
        final Object lock = new Object();
        final String[] response = new String[1];
        ConnectorListener listener = new ConnectorListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void messageReceived(String message) {
                String[] stringArray = responseHeaders;
                int n = 0;
                int n2 = stringArray.length;
                while (n < n2) {
                    String responseHeader = stringArray[n];
                    if (message.startsWith(responseHeader)) {
                        response[0] = message;
                        Object object = lock;
                        synchronized (object) {
                            lock.notify();
                        }
                        return;
                    }
                    ++n;
                }
            }
        };
        this.addConnectorListener(listener, false);
        Object object = lock;
        synchronized (object) {
            try {
                try {
                    if (this.isDebug()) {
                        System.out.println("-> " + command);
                    }
                    this.sendCommand(command);
                    lock.wait(this.commandResponseTime);
                }
                catch (InterruptedException e) {
                    throw new TimeOutException("'" + command + "' is not executed");
                }
            }
            finally {
                this.removeConnectorListener(listener);
            }
        }
        return response[0];
    }

    private void assureAttached() throws ConnectorException {
        if (this.getStatus() != Status.ATTACHED || !this.ping()) {
            this.connect();
        }
        if (this.getStatus() != Status.ATTACHED) {
            throw new NotAttachedException();
        }
    }

    private boolean ping() throws ConnectorException {
        this.execute("PING", "PONG", false);
        return true;
    }

    public final void addConnectorListener(ConnectorListener listener) throws ConnectorException {
        this.addConnectorListener(listener, true);
    }

    protected final void addConnectorListener(ConnectorListener listener, boolean checkAttached) throws ConnectorException {
        if (checkAttached) {
            this.assureAttached();
        }
        Utils.checkNotNull("listener", listener);
        this.listeners.add(listener);
    }

    public final void removeConnectorListener(ConnectorListener listener) {
        Utils.checkNotNull("listener", listener);
        this.listeners.remove(listener);
    }

    protected final void fireMessageReceived(final String message) {
        assert (message != null);
        new Thread("Win32MessageSender"){

            public void run() {
                ConnectorListener[] listeners;
                ConnectorListener[] connectorListenerArray = listeners = Connector.this.listeners.toArray(new ConnectorListener[0]);
                int n = 0;
                int n2 = connectorListenerArray.length;
                while (n < n2) {
                    ConnectorListener listener = connectorListenerArray[n];
                    listener.messageReceived(message);
                    ++n;
                }
            }
        }.start();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        ATTACHED,
        REFUSED,
        NOT_AVAILABLE,
        PENDING_AUTHORIZATION,
        NOT_RUNNING;

    }
}

