/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.skype.connector.win32;

import java.io.UnsupportedEncodingException;
import jp.sf.skype.connector.Connector;
import jp.sf.skype.connector.ConnectorException;
import jp.sf.skype.connector.ConnectorListener;
import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Display;

public final class Win32Connector
extends Connector {
    private static final int ATTACH_SUCCESS = 0;
    private static final int ATTACH_PENDING_AUTHORIZATION = 1;
    private static final int ATTACH_REFUSED = 2;
    private static final int ATTACH_NOT_AVAILABLE = 3;
    private static final int HWND_BROADCAST = 65535;
    private static final int WM_COPYDATA = 74;
    private static final int ATTACH_MESSAGE_ID = OS.RegisterWindowMessage((TCHAR)new TCHAR(0, "SkypeControlAPIAttach", true));
    private static final int DISCOVER_MESSAGE_ID = OS.RegisterWindowMessage((TCHAR)new TCHAR(0, "SkypeControlAPIDiscover", true));
    private Display display;
    private TCHAR windowClass;
    private int windowHandle;
    private int skypeWindowHandle;
    private Connector.Status status = Connector.Status.NOT_RUNNING;

    public Win32Connector() {
        this.initResource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initResource() {
        final Object object = new Object();
        Thread thread = new Thread("Win32EventDispatcher"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Win32Connector.this.display = new Display();
                Win32Connector.this.windowClass = new TCHAR(0, "" + System.currentTimeMillis() + (int)(Math.random() * 1000.0), true);
                int messageReceived = new Callback((Object)Win32Connector.this, "messageReceived", 4).getAddress();
                if (messageReceived == 0) {
                    SWT.error((int)3);
                }
                int hHeap = OS.GetProcessHeap();
                int hInstance = OS.GetModuleHandle(null);
                WNDCLASS lpWndClass = new WNDCLASS();
                lpWndClass.hInstance = hInstance;
                lpWndClass.lpfnWndProc = messageReceived;
                lpWndClass.style = 8200;
                lpWndClass.hCursor = OS.LoadCursor((int)0, (int)32512);
                int byteCount = Win32Connector.this.windowClass.length() * TCHAR.sizeof;
                lpWndClass.lpszClassName = OS.HeapAlloc((int)hHeap, (int)8, (int)byteCount);
                OS.MoveMemory((int)lpWndClass.lpszClassName, (TCHAR)Win32Connector.this.windowClass, (int)byteCount);
                OS.RegisterClass((WNDCLASS)lpWndClass);
                Win32Connector.this.windowHandle = OS.CreateWindowEx((int)0, (TCHAR)Win32Connector.this.windowClass, null, (int)OS.WS_OVERLAPPED, (int)0, (int)0, (int)0, (int)0, (int)0, (int)0, (int)hInstance, null);
                Object object2 = object;
                synchronized (object2) {
                    object.notify();
                }
                while (true) {
                    if (Win32Connector.this.display.readAndDispatch()) {
                        continue;
                    }
                    Win32Connector.this.display.sleep();
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
        Object object2 = object;
        synchronized (object2) {
            try {
                object.wait(1000L);
            }
            catch (InterruptedException e) {
                throw new InternalError("win32 connector is not initialized");
            }
        }
    }

    protected Connector.Status connect(int timeOut) throws ConnectorException {
        if (this.getStatus() != Connector.Status.ATTACHED) {
            this.initConnection(timeOut);
        }
        return this.getStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initConnection(int timeOut) throws ConnectorException {
        final Object object = new Object();
        ConnectorListener listener = new ConnectorListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void messageReceived(String message) {
                if (message.startsWith("TRIED TO ATTACH")) {
                    Win32Connector.this.removeConnectorListener(this);
                    Object object2 = object;
                    synchronized (object2) {
                        object.notify();
                    }
                }
            }
        };
        this.addConnectorListener(listener, false);
        Object object2 = object;
        synchronized (object2) {
            block5: {
                OS.SendMessage((int)65535, (int)DISCOVER_MESSAGE_ID, (int)this.windowHandle, (int)0);
                try {
                    object.wait(timeOut);
                }
                catch (InterruptedException e) {
                    if (this.status == Connector.Status.PENDING_AUTHORIZATION) break block5;
                    this.status = Connector.Status.NOT_RUNNING;
                }
            }
        }
    }

    int messageReceived(int hwnd, int msg, int wParam, int lParam) {
        if (msg == ATTACH_MESSAGE_ID) {
            if (lParam == 1) {
                this.status = Connector.Status.PENDING_AUTHORIZATION;
                return 1;
            }
            switch (lParam) {
                case 0: {
                    this.skypeWindowHandle = wParam;
                    this.status = Connector.Status.ATTACHED;
                    break;
                }
                case 2: {
                    this.status = Connector.Status.REFUSED;
                    break;
                }
                case 3: {
                    this.status = Connector.Status.NOT_AVAILABLE;
                }
            }
            this.fireMessageReceived("TRIED TO ATTACH");
            return 1;
        }
        if (msg == 74 && wParam == this.skypeWindowHandle) {
            int[] data = new int[3];
            OS.MoveMemory((int[])data, (int)lParam, (int)12);
            int cbData = data[1];
            int lpData = data[2];
            int length = cbData;
            byte[] buffer = new byte[length];
            OS.MoveMemory((byte[])buffer, (int)lpData, (int)length);
            byte[] string = new byte[buffer.length - 1];
            System.arraycopy(buffer, 0, string, 0, string.length);
            try {
                String message = new String(string, "UTF-8");
                this.fireMessageReceived(message);
                return 1;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return OS.DefWindowProc((int)hwnd, (int)msg, (int)wParam, (int)lParam);
    }

    public Connector.Status getStatus() {
        return this.status;
    }

    protected void sendCommand(final String command) {
        this.display.asyncExec(new Runnable(){

            public void run() {
                try {
                    byte[] data = (String.valueOf(command) + "\u0000").getBytes("UTF-8");
                    int hHeap = OS.GetProcessHeap();
                    int pMessage = OS.HeapAlloc((int)hHeap, (int)8, (int)data.length);
                    OS.MoveMemory((int)pMessage, (byte[])data, (int)data.length);
                    int[] nArray = new int[3];
                    nArray[1] = data.length;
                    nArray[2] = pMessage;
                    OS.SendMessage((int)Win32Connector.this.skypeWindowHandle, (int)74, (int)Win32Connector.this.windowHandle, (int[])nArray);
                    OS.HeapFree((int)hHeap, (int)0, (int)pMessage);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
        });
    }
}

