/*******************************************************************************
 * Copyright (c) 2006 Koji Hisano <hisano@gmail.com>
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 *     Koji Hisano - initial API and implementation
 *******************************************************************************/
package jp.sf.skype;

import java.io.File;
import junit.framework.TestCase;

public class DialogAPITest extends TestCase {
    public void testShowMainWindow() throws Exception {
        Skype.showSkypeWindow();
        TestUtils.showCheckDialog("SkypẽCEBhEőOʂɕ\Ă܂H");
        Skype.hideSkypeWindow();
        TestUtils.showCheckDialog("SkypẽCEBhEŏĂ܂H");
    }

    public void testShowAddFriendWindow() throws Exception {
        Skype.showAddFriendWindow();
        TestUtils.showCheckDialog("R^Ng֒ǉEBhE\Ă܂H");
        TestUtils.showMessageDialog("֐iޑOɃR^Ng֒ǉEBhEĂ");
        Skype.showAddFriendWindow(TestData.getFriendId());
        TestUtils.showCheckDialog(TestData.getFriendId() + "炩ߐݒ肳ꂽԂ[R^Ng֒ǉ]EBhE\Ă܂H");
        TestUtils.showMessageDialog("֐iޑO[R^Ng֒ǉ]EBhEĂ");
    }

    public void testShowChatWindow() throws Exception {
        Skype.showChatWindow(TestData.getFriendId());
        TestUtils.showCheckDialog(TestData.getFriendId() + "Ƃ̃`bgEBhE\Ă܂H");
        TestUtils.showMessageDialog("֐iޑOɃ`bgEBhEĂ");
        Skype.showChatWindow(TestData.getFriendId(), "Hello, World!");
        TestUtils.showCheckDialog("Hello, World!炩ߓ͂ꂽԂ" + TestData.getFriendId() + "Ƃ̃`bgEBhE\Ă܂H");
        TestUtils.showMessageDialog("֐iޑOɃ`bgEBhEĂ");
    }

    public void testShowFileTransferWindow() throws Exception {
        Skype.showFileTransferWindow(TestData.getFriendId());
        TestUtils.showCheckDialog(TestData.getFriendId() + "֑Mt@C̑IEBhE\Ă܂H");
        TestUtils.showMessageDialog("֐iޑOɑIEBhEĂ");
        Skype.showFileTransferWindow(TestData.getFriendId(), new File("C:\\"));
        TestUtils.showCheckDialog("C:\\炩ߑIꂽԂ" + TestData.getFriendId() + "֑Mt@C̑IEBhE\Ă܂H");
        TestUtils.showMessageDialog("֐iޑOɑIEBhEĂ");
    }

    public void testShowProfileWindow() throws Exception {
        Skype.showProfileWindow();
        TestUtils.showCheckDialog("vtB[EBhE\Ă܂H");
        TestUtils.showMessageDialog("֐iޑOɃvtB[EBhEĂ");
    }

    public void testShowUserInformationWindow() throws Exception {
        Skype.showUserInformationWindow(TestData.getFriendId());
        TestUtils.showCheckDialog(TestData.getFriendId() + "̃vtB[EBhE\Ă܂H");
        TestUtils.showMessageDialog("֐iޑOɃvtB[EBhEĂ");
    }

    public void testShowConferenceWindow() throws Exception {
        Skype.showConferenceWindow();
        TestUtils.showCheckDialog("[Ucʘbɏ҃EBhE\Ă܂H");
        TestUtils.showMessageDialog("֐iޑOɃ[Ucʘbɏ҃EBhEĂ");
    }

    public void testShowSearchWindow() throws Exception {
        Skype.showSearchWindow();
        TestUtils.showCheckDialog("Skype[ǓEBhE\Ă܂H");
        TestUtils.showMessageDialog("֐iޑOSkype[ǓEBhEĂ");
    }

    public void testShowOptionsWindow() throws Exception {
        Skype.showOptionsWindow(Skype.OptionsPage.ADVANCED);
        TestUtils.showCheckDialog("gy[W炩ߑIꂽԂŐݒEBhE\Ă܂H");
        TestUtils.showMessageDialog("֐iޑOɃ[UݒEBhEĂ");
    }
}
