/*
 * Decompiled with CFR 0.152.
 */
package com.hexidec.ekit;

import com.hexidec.ekit.UndoSet;
import java.util.ArrayList;

public class GSHTMLUndoManager {
    protected int counter = 0;
    protected int maxundo = 100;
    protected boolean undoflg = false;
    protected ArrayList<UndoSet> undoList = new ArrayList();

    public GSHTMLUndoManager() {
    }

    public GSHTMLUndoManager(int maxundo) {
        this.maxundo = maxundo;
    }

    public void add(String source, int position) {
        String sourceBody = this.getBody(source);
        if (this.undoList.size() != 0) {
            String oldsource = this.undoList.get(this.undoList.size() - 1).getSource();
            String oldsourceBody = oldsource;
            if (oldsourceBody.equals(sourceBody)) {
                return;
            }
            if (oldsource.equals(source)) {
                return;
            }
        }
        if (this.counter >= 0) {
            if (this.undoList.size() <= this.counter) {
                this.counter = this.undoList.size() - 1;
            }
            if (this.undoList.size() - 1 != this.counter) {
                ArrayList<UndoSet> temp = new ArrayList<UndoSet>();
                int i = 0;
                while (i <= this.counter) {
                    temp.add(this.undoList.get(i));
                    ++i;
                }
                this.undoList = temp;
            }
        } else if (this.undoflg) {
            this.undoList.clear();
        }
        if (this.undoList.size() >= this.maxundo) {
            this.undoList.remove(0);
        }
        UndoSet undoSet = new UndoSet();
        undoSet.setPosition(position);
        undoSet.setSource(sourceBody);
        this.undoList.add(undoSet);
        this.counter = this.undoList.size() - 1;
        this.undoflg = false;
    }

    public String getOldsource() {
        if (this.undoList.size() != 0) {
            String oldsource = this.undoList.get(this.undoList.size() - 1).getSource();
            return oldsource;
        }
        return null;
    }

    public UndoSet undo() {
        this.undoflg = true;
        if (this.undoList.size() <= this.counter) {
            this.counter = this.undoList.size() - 1;
        }
        if (1 > this.counter) {
            return null;
        }
        UndoSet source = this.undoList.get(this.counter - 1);
        --this.counter;
        return source;
    }

    public UndoSet redo() {
        ++this.counter;
        if (this.counter < 0) {
            this.counter = 1;
        }
        if (this.undoList.size() <= this.counter) {
            return null;
        }
        UndoSet source = this.undoList.get(this.counter);
        return source;
    }

    public boolean canUndo() {
        if (this.counter < 0) {
            return false;
        }
        return this.undoList.size() > this.counter;
    }

    public boolean isUndo() {
        if (this.undoflg) {
            this.undoflg = false;
            return true;
        }
        return false;
    }

    public String getBody(String source) {
        String docTextCase = source;
        String containingTag = "body";
        int tagStart = docTextCase.indexOf("<" + containingTag.toLowerCase());
        int tagStartClose = docTextCase.indexOf(">", tagStart) + 1;
        String closeTag = "</" + containingTag.toLowerCase() + ">";
        int tagEndOpen = docTextCase.indexOf(closeTag);
        if (tagStartClose < 0) {
            tagStartClose = 0;
        }
        if (tagEndOpen < 0 || tagEndOpen > docTextCase.length()) {
            tagEndOpen = docTextCase.length();
        }
        String bodyText = source.substring(tagStartClose, tagEndOpen);
        bodyText = bodyText.replaceAll("\r", "");
        bodyText = bodyText.replaceAll("\n", "");
        bodyText = bodyText.replaceAll("\r\n", "");
        return bodyText.trim();
    }
}

