/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.hokudai.meme.core_smart_gs.test;

import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import jp.ac.hokudai.meme.core_smart_gs.InvalidDataFormatException;
import jp.ac.hokudai.meme.core_smart_gs.searcher.DocumentSearcher;
import jp.ac.hokudai.meme.core_smart_gs.searcher.IDocumentSearcher;
import jp.ac.hokudai.meme.core_smart_gs.searcher.PagedRect;
import jp.ac.hokudai.meme.core_smart_gs.searcher.QueryRect;
import jp.ac.hokudai.meme.core_smart_gs.searcher.ResultRects;

public class TestRectConfirm {
    private IDocumentSearcher searchEngine_ = DocumentSearcher.getInstance(1);
    private QueryRect query_;

    public void loadDscFile(File dscFile) throws IOException {
        try {
            this.searchEngine_.addDscFile(new File[]{dscFile});
        }
        catch (InvalidDataFormatException e) {
            e.printStackTrace();
        }
    }

    public void setQueryRect(int queryPageIndex, Rectangle2D rect) {
        PagedRect pagedRect = new PagedRect(queryPageIndex, new Rectangle((int)rect.getX(), (int)(rect.getY() + rect.getHeight() / 2.0), (int)rect.getWidth(), 1));
        this.query_ = new QueryRect();
        this.query_.addQueryPRect(pagedRect);
        PagedRect[] queryRects = this.searchEngine_.rectConfirm(this.query_).getAllRects();
    }

    public ResultRects search() {
        ResultRects results = this.searchEngine_.search(this.query_);
        int i = 1;
        while (i <= results.getSize()) {
            PagedRect[] prect = results.getPRects(i);
            Rectangle firstRect = prect[0].getRect();
            Rectangle lastRect = prect[prect.length - 1].getRect();
            int width = lastRect.x - firstRect.x + lastRect.width;
            Rectangle resRect = new Rectangle(firstRect.x, firstRect.y, width, firstRect.height);
            int n = prect[0].getPageIndex();
            ++i;
        }
        return results;
    }

    public static void main(String[] args) throws IOException {
        String filePath = "D:/sandbox/core_smart_gs/debug/002-003.dsc";
        TestRectConfirm test = new TestRectConfirm();
        File dscFile = new File(filePath);
        test.loadDscFile(dscFile);
        int page = 0;
        double x = 288.0;
        double y = 418.0;
        double w = 83.0;
        double h = 61.0;
        Rectangle2D.Double rect = new Rectangle2D.Double(x, y, w, h);
        test.setQueryRect(page, rect);
        ResultRects rects = test.search();
        System.out.println("done.");
    }
}

