/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.connection;

import java.awt.Frame;
import java.awt.Point;
import javax.swing.JOptionPane;
import reasoning_web.logical.Connection;
import smart_gs.connection.lastConnectionToConfirmAndEditFrame;
import smart_gs.logical.GSResource;
import smart_gs.logical.Preference;
import smart_gs.logical.URIObject;
import smart_gs.reasoning_web.ExternalLinkDialog;
import smart_gs.reasoning_web.logical.GSExplanatoryNote;
import smart_gs.reasoning_web.logical.GS_RWElement;
import smart_gs.reasoning_web.logical.GS_RWRepository;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.util.HrefChecker;
import sml_editor.swingui.EditorTextPane;

public class ConnectionCreator {
    private static final int NOTHING_HAS_BEEN_SET = 0;
    private static final int SOURCE_HAS_BEEN_SET = 1;
    private static final int TARGET_HAS_BEEN_SET = 2;
    public static final String EXTERNAL_LINK = "external";
    private static int makingLink = 0;
    private static GS_RWElement tmpSource = null;
    private static GS_RWElement tmpTarget = null;

    public static boolean isMakingLink() {
        return makingLink == 1 || makingLink == 2;
    }

    public static boolean isMakingLinkSourceAlreadySet() {
        return makingLink == 1;
    }

    public static boolean isMakingLinkTargetAlreadySet() {
        return makingLink == 2;
    }

    private static void setMakingLink(int makingLink) {
        ConnectionCreator.makingLink = makingLink;
    }

    private static void ShowLastConnectionToConfirmAndEdit() {
        Connection newestConnection = GS_RWRepository.getInstance().getNewestConnection();
        new lastConnectionToConfirmAndEditFrame(newestConnection, "Created Connection").setVisible(true);
    }

    public static void setSource(GS_RWElement source) {
        if (!ConnectionCreator.isMakingLink()) {
            tmpSource = source;
            WorkspaceWindow.getInstance().setStatusBarSource(source.getURI());
            ConnectionCreator.setMakingLink(1);
            return;
        }
        if (ConnectionCreator.isMakingLinkTargetAlreadySet()) {
            if (tmpTarget == null) {
                int answer = JOptionPane.showConfirmDialog(new Frame(), "Bug!: link target doesn't exist", "Information", -1);
                return;
            }
            GSExplanatoryNote note = new GSExplanatoryNote("<xml></xml>");
            GS_RWRepository.getInstance().createConnection(source, tmpTarget, note);
            ConnectionCreator.setDefaultNameOfNewestConnection();
            WorkspaceWindow.getInstance().setStatusBarSource(source.getURI());
            if (tmpTarget instanceof GSResource) {
                ConnectionCreator.ShowLastConnectionToConfirmAndEdit();
            }
            tmpSource = null;
            tmpTarget = null;
            ConnectionCreator.setMakingLink(0);
            WorkspaceWindow.getInstance().resetStatusBar();
            return;
        }
        if (ConnectionCreator.isMakingLinkSourceAlreadySet()) {
            return;
        }
    }

    public static void setTarget(GS_RWElement target) {
        if (!ConnectionCreator.isMakingLink()) {
            tmpTarget = target;
            WorkspaceWindow.getInstance().setStatusBarTarget(target.getURI());
            ConnectionCreator.setMakingLink(2);
            return;
        }
        if (ConnectionCreator.isMakingLinkSourceAlreadySet()) {
            if (tmpSource == null) {
                int answer = JOptionPane.showConfirmDialog(new Frame(), "Bug!: link source doesn't exist", "Information", -1);
                return;
            }
            GSExplanatoryNote note = new GSExplanatoryNote("<xml></xml>");
            GS_RWRepository.getInstance().createConnection(tmpSource, target, note);
            ConnectionCreator.setDefaultNameOfNewestConnection();
            WorkspaceWindow.getInstance().setStatusBarTarget(target.getURI());
            if (target instanceof GSResource) {
                ConnectionCreator.ShowLastConnectionToConfirmAndEdit();
            }
            tmpSource = null;
            tmpTarget = null;
            ConnectionCreator.setMakingLink(0);
            WorkspaceWindow.getInstance().resetStatusBar();
            return;
        }
        if (ConnectionCreator.isMakingLinkTargetAlreadySet()) {
            return;
        }
    }

    public static void cancaelConnectionCreation() {
        tmpSource = null;
        tmpTarget = null;
        ConnectionCreator.setMakingLink(0);
        WorkspaceWindow.getInstance().resetStatusBar();
    }

    public static void setExternal(GS_RWElement target, EditorTextPane textPane, Point point) {
        String urlStr = null;
        String checkURL = textPane.getSelectURLStr(point);
        int checkid = HrefChecker.check(checkURL);
        if (checkid == -1) {
            urlStr = checkURL;
        }
        ExternalLinkDialog externalLinkDialog = new ExternalLinkDialog((Frame)WorkspaceWindow.getInstance(), urlStr);
        externalLinkDialog.setLocationRelativeTo(null);
        externalLinkDialog.setVisible(true);
        if (!externalLinkDialog.isCancel()) {
            String registUrl = externalLinkDialog.getUrl();
            textPane.setURL(point, registUrl);
        }
    }

    public static void removeExternal(GS_RWElement target, EditorTextPane textPane, Point point) {
        textPane.removeURL(point);
    }

    public static boolean isSourceSet() {
        return tmpSource != null;
    }

    public static GS_RWElement getSource() {
        return tmpSource;
    }

    public static boolean isTargetSet() {
        return tmpTarget != null;
    }

    public static GS_RWElement getTarget() {
        return tmpTarget;
    }

    private static void setDefaultNameOfNewestConnection() {
        String date = URIObject.getDate();
        String userName = Preference.getInstance().getUserName();
        GS_RWRepository.getInstance().getNewestConnection().setName(String.valueOf(userName) + "@" + date);
    }
}

