/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.image_search;

import image_search.Query;
import java.awt.Rectangle;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.ac.hokudai.meme.core_smart_gs.searcher.FoundRect;
import jp.ac.hokudai.meme.core_smart_gs.searcher.InputStreamThread;
import jp.ac.hokudai.meme.core_smart_gs.searcher.PagedPolygon;
import jp.ac.hokudai.meme.core_smart_gs.searcher.PagedRect;
import jp.ac.hokudai.meme.core_smart_gs.searcher.PolygonParser;
import jp.ac.hokudai.meme.core_smart_gs.searcher.ResultRects;
import smart_gs.SmartGS;
import smart_gs.image_search.logical.TextType;
import smart_gs.logical.Spread;
import smart_gs.util.CanonicalPathString;

public class ExternalSearchEngineController {
    private File assignListFile;
    private Process p;
    private InputStreamThread it;
    private InputStreamThread et;
    private BufferedWriter bw;
    private ResultRects resultRects = new ResultRects();
    private ArrayList<String> resultStrings = new ArrayList();
    static final String COM_ASSIGN = "assign";
    static final String COM_SEARCH = "search";
    static final String COM_EXIT = "exit";
    static final String PREFIX_P0 = "p0";
    static final String PREFIX_X = "x";
    static final String PREFIX_Y = "y";
    static final String REGEXP_RECORD = "r(\\d+)d(\\d+\\.?\\d+)(.*)";
    static final String MSG_OK = "OK";
    static final String RECORD_EOD = "EOD";
    static final String ERRMSG_PARSE = "Internal Error: parse error";

    public ResultRects search(Query query, List<Spread> spreads) {
        this.assignListFile = this.makeAssignListFile(spreads);
        this.startExternalSearchEngine();
        this.execAssign(this.assignListFile);
        this.execSearch(query, 1, 100);
        this.execExit();
        this.stopExternalSearchEngine();
        return this.getResultRectsFromStrings(this.resultStrings);
    }

    public File makeAssignListFile(List<Spread> spreads) {
        File file = new File(SmartGS.getImageSearchAssignlistfilePathString());
        try {
            HashMap<String, String> dscLocation = new HashMap<String, String>();
            file.createNewFile();
            FileOutputStream fos = new FileOutputStream(SmartGS.getImageSearchAssignlistfilePathString());
            OutputStreamWriter osw = new OutputStreamWriter(fos);
            BufferedWriter bw = new BufferedWriter(osw);
            int i = 0;
            while (i < spreads.size()) {
                if (spreads.get(i).getDscFile() != null) {
                    bw.write(CanonicalPathString.get(spreads.get(i).getFile()));
                    bw.newLine();
                    String bmp = spreads.get(i).getFile().getParent();
                    String dsc = spreads.get(i).getDscFile().getParent();
                    dscLocation.put(bmp, dsc);
                }
                ++i;
            }
            bw.close();
            osw.close();
            fos.close();
            for (String key : dscLocation.keySet()) {
                File f = new File(String.valueOf(key) + "/DscLocation");
                FileOutputStream fosd = new FileOutputStream(f);
                OutputStreamWriter oswd = new OutputStreamWriter(fosd);
                BufferedWriter bwd = new BufferedWriter(oswd);
                bwd.write((String)dscLocation.get(key));
                bwd.close();
                oswd.close();
                fosd.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return file;
    }

    public void startExternalSearchEngine() {
        try {
            this.p = Runtime.getRuntime().exec(SmartGS.getImageSearchExefilePathString());
            this.it = new InputStreamThread(this.p.getInputStream(), 0, this);
            this.it.start();
            this.et = new InputStreamThread(this.p.getErrorStream(), 1, this);
            this.et.start();
            this.bw = new BufferedWriter(new OutputStreamWriter(this.p.getOutputStream()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void execAssign(File file) {
        try {
            this.bw.write("assign " + CanonicalPathString.get(file));
            System.out.println("assign " + CanonicalPathString.get(file));
            this.bw.newLine();
            this.bw.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void execSearch(Query query, int first, int count) {
        String queryString = this.getStringFromRectangle(query.getRectangle());
        try {
            this.bw.write("search " + queryString + " " + first + " " + count);
            System.out.println("search " + queryString + " " + first + " " + count);
            this.bw.newLine();
            this.bw.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void execExit() {
        try {
            this.bw.write(COM_EXIT);
            this.bw.newLine();
            this.bw.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void stopExternalSearchEngine() {
        try {
            this.it.join();
            this.et.join();
            this.p.getInputStream().close();
            this.p.getOutputStream().close();
            this.p.getErrorStream().close();
            this.p.destroy();
            this.assignListFile.delete();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void addSearchResult(String str) {
        if (str.equals(MSG_OK)) {
            return;
        }
        this.resultStrings.add(str);
    }

    public String getStringFromRectangle(Rectangle rect) {
        StringBuffer queryStringBuffer = new StringBuffer();
        queryStringBuffer.append(PREFIX_P0);
        queryStringBuffer.append(PREFIX_X);
        queryStringBuffer.append((int)rect.getX());
        queryStringBuffer.append(PREFIX_Y);
        queryStringBuffer.append((int)rect.getY());
        if (TextType.isHorizontal()) {
            queryStringBuffer.append(PREFIX_X);
            queryStringBuffer.append((int)rect.getX() + (int)rect.getWidth());
            queryStringBuffer.append(PREFIX_Y);
            queryStringBuffer.append((int)rect.getY());
        } else {
            queryStringBuffer.append(PREFIX_X);
            queryStringBuffer.append((int)rect.getX());
            queryStringBuffer.append(PREFIX_Y);
            queryStringBuffer.append((int)rect.getY() + (int)rect.getHeight());
        }
        return queryStringBuffer.toString();
    }

    public ResultRects getResultRectsFromStrings(ArrayList<String> strs) {
        for (String recordString : strs) {
            if (recordString.equals(RECORD_EOD)) break;
            Pattern pat = Pattern.compile(REGEXP_RECORD);
            Matcher mat = pat.matcher(recordString);
            if (!mat.find()) {
                throw new RuntimeException(new ParseException(ERRMSG_PARSE, 0));
            }
            PolygonParser parser = new PolygonParser(mat.group(3));
            try {
                List<PagedPolygon> polygon = parser.getPolygon();
                PagedRect[] pagedRects = new PagedRect[polygon.size()];
                int idx = 0;
                for (PagedPolygon pagedPolygon : polygon) {
                    pagedRects[idx] = new PagedRect(pagedPolygon.getPageNum(), pagedPolygon.getPolygon().getBounds(), -1, -1);
                    ++idx;
                }
                FoundRect foundRect = new FoundRect(pagedRects, Double.parseDouble(mat.group(2)));
                this.resultRects.addResult(foundRect);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
        return this.resultRects;
    }
}

