/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.image_search.logical;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import smart_gs.image_search.logical.GSQuery;
import smart_gs.image_search.normal.swingui.BucketFrame;
import smart_gs.image_search.normal.swingui.Observer;
import smart_gs.reasoning_web.logical.GS_RWElement;
import smart_gs.reasoning_web.logical.GS_RWPackage;
import smart_gs.reasoning_web.logical.XML2RWElementConverter;

public class QueryBucket
extends GS_RWPackage {
    private List<Observer> observers = new ArrayList<Observer>();

    public QueryBucket(String uri, String originalURI, String version) {
        super(uri, originalURI, version);
    }

    public QueryBucket() {
    }

    public void add(GSQuery query) {
        super.add(query);
        this.notifyChange();
    }

    public GSQuery get(int index) {
        return (GSQuery)this.getElements().get(index);
    }

    public void remove(int index) {
        if (index < 0 || index > this.size()) {
            return;
        }
        this.getElements().remove(index);
        this.notifyChange();
    }

    public int size() {
        return this.getElements().size();
    }

    private void notifyChange() {
        int i = 0;
        while (i < this.observers.size()) {
            this.observers.get(i).update();
            ++i;
        }
    }

    public void addObserver(Observer panel) {
        this.observers.add(panel);
    }

    @Override
    public void show() {
        BucketFrame bf = new BucketFrame(this);
        bf.validate();
        bf.pack();
        bf.setVisible(true);
    }

    @Override
    public Element createXMLElement(Document document) {
        Element element = document.createElement("bucket");
        element.setAttribute("name", this.name);
        element.setAttribute("source", this.source);
        element.setAttribute("uri", this.uri);
        element.setAttribute("originalURI", this.originalURI);
        int i = 0;
        while (i < this.elements.size()) {
            Element elem = ((GS_RWElement)this.elements.get(i)).createXMLElement(document);
            element.appendChild(elem);
            ++i;
        }
        return element;
    }

    public static QueryBucket restore(Element elem) {
        String name = elem.getAttribute("name");
        String source = elem.getAttribute("source");
        String uri = elem.getAttribute("uri");
        String originalURI = elem.getAttribute("originalURI");
        String version = elem.getAttribute("version");
        QueryBucket gsPackage = new QueryBucket(uri, originalURI, version);
        gsPackage.setName(name);
        gsPackage.setSource(source);
        NodeList children = elem.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node node = children.item(i);
            if (node.getNodeType() == 1) {
                GS_RWElement resource = XML2RWElementConverter.convert((Element)node);
                if (resource == null) {
                    System.out.println(String.format("Error: an member of a QueryBucket %s is not found and skipped. its XML-form is %s", elem, (Element)node));
                } else {
                    gsPackage.add(resource);
                }
            }
            ++i;
        }
        return gsPackage;
    }

    @Override
    public String getTypeString() {
        return "bucket";
    }
}

