/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.image_search.research.swingui;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import smart_gs.image_search.logical.GSQuery;
import smart_gs.image_search.research.RESearch;
import smart_gs.image_search.research.SearchResultSet;
import smart_gs.image_search.research.swingui.RESearchResultViewer;
import smart_gs.logical.Region;
import smart_gs.logical.Spread;
import smart_gs.logical.SpreadTree;
import smart_gs.smleditor.swingui.GSEditorFrame;
import smart_gs.util.RegionSelectionDialog;

public class REImageSearchDialog
extends RegionSelectionDialog {
    private JRadioButton all;
    private JRadioButton currentDirectory;
    private JRadioButton spreadButton;
    private JRadioButton lineButton;
    private JTextField lineField;
    private JRadioButton selectSpread;
    private JTextField pageSelectField;

    public REImageSearchDialog(GSEditorFrame parent) {
        super(parent);
        this.addRegionButton.setText("add Query");
        parent.getFrame().setTitle("Search Dialog");
        this.lineField = new JTextField(2);
        JPanel panel = new JPanel(new GridLayout(2, 1));
        JPanel rePanel = new JPanel(new GridLayout(2, 1));
        JPanel linePanel = new JPanel(new FlowLayout(0));
        this.spreadButton = new JRadioButton("spread");
        this.spreadButton.setSelected(true);
        this.lineButton = new JRadioButton("line");
        ButtonGroup reGroup = new ButtonGroup();
        reGroup.add(this.spreadButton);
        reGroup.add(this.lineButton);
        rePanel.add(this.spreadButton);
        linePanel.add(this.lineButton);
        linePanel.add(this.lineField);
        rePanel.add(linePanel);
        JPanel scopePanel = new JPanel(new GridLayout(4, 1));
        scopePanel.setBorder(new TitledBorder("Search Scope"));
        this.all = new JRadioButton("All Spreads");
        this.all.setSelected(true);
        this.currentDirectory = new JRadioButton("Current Directory");
        this.selectSpread = new JRadioButton("Select Spread");
        this.pageSelectField = new JTextField(10);
        ButtonGroup group = new ButtonGroup();
        group.add(this.all);
        group.add(this.currentDirectory);
        group.add(this.selectSpread);
        scopePanel.add(this.all);
        scopePanel.add(this.currentDirectory);
        scopePanel.add(this.pageSelectField);
        panel.add(rePanel);
        panel.add(scopePanel);
        this.southPanel.add((Component)panel, "Center");
        this.setSize(400, 500);
    }

    public boolean isLineSelected() {
        return this.lineButton.isSelected();
    }

    public int getLineNumber() {
        return new Integer(this.lineField.getText());
    }

    private List<Spread> getSpreadsToSearch() {
        if (this.all.isSelected()) {
            return SpreadTree.getInstance().getSpreads();
        }
        if (this.currentDirectory.isSelected()) {
            return SpreadTree.getInstance().getCurrentDirectory().getSpreads();
        }
        return null;
    }

    @Override
    protected void ok() {
        super.ok();
        ArrayList<GSQuery> queries = new ArrayList<GSQuery>();
        int i = 0;
        while (i < this.regions.size()) {
            Region region = (Region)this.regions.get(i);
            Spread spread = region.getSpread();
            Rectangle rect = region.getView().getRectangle();
            GSQuery query = new GSQuery(spread, spread.getDscFile(), rect);
            queries.add(query);
            ++i;
        }
        List<Spread> spreads = this.getSpreadsToSearch();
        ArrayList<Spread> spreadsToSearch = new ArrayList<Spread>();
        int i2 = 0;
        while (i2 < spreads.size()) {
            if (spreads.get(i2).hasDscFile()) {
                spreadsToSearch.add(spreads.get(i2));
            }
            ++i2;
        }
        RESearch searcher = new RESearch(this, queries, spreadsToSearch);
        searcher.execute();
        List<SearchResultSet> results = searcher.getResults();
        new RESearchResultViewer(queries, results).setVisible(true);
    }
}

