/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.logical;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import reasoning_web.logical.inter_face.NoWayToShowException;
import smart_gs.drawing_tool.view.View;
import smart_gs.logical.GSResource;
import smart_gs.logical.Markup;
import smart_gs.logical.Spread;
import smart_gs.logical.URICreator;
import smart_gs.logical.visitor.Visitor;
import smart_gs.menu.action.SpreadJumpAction;
import smart_gs.menu.action.SpreadOpenAction;
import smart_gs.reasoning_web.swingui.elementViewPanelListener;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.util.ImageCropper;

public class Region
extends GSResource
implements Markup {
    protected Spread spread;
    protected View view;
    protected String baseURI;
    public List<Point2D> points;
    private boolean isLineSegment;
    private String timeZone;
    private String protection = "normal";
    public static final String PROTECTED = "protected";
    public static final String NORMAL = "normal";
    private static int id = 1;
    protected boolean centermode = false;

    public Region(Spread spread, View view, String uri, String originalURI, String version) {
        this.baseURI = String.valueOf(spread.createOldVersionURI()) + view.getTypeString() + "/";
        this.spread = spread;
        this.view = view;
        this.setId(++id - 1);
        WorkspaceWindow.setUpdated(true);
        this.isLineSegment = false;
        this.setURIs(uri, originalURI);
        this.setVersion(version);
    }

    public Region(Spread spread, View view) {
        this.baseURI = String.valueOf(spread.createOldVersionURI()) + view.getTypeString() + "/";
        this.spread = spread;
        this.view = view;
        this.setId(++id - 1);
        WorkspaceWindow.setUpdated(true);
        this.isLineSegment = false;
        this.setURIs();
    }

    protected Region(Spread spread, String type) {
        this.baseURI = String.valueOf(spread.createOldVersionURI()) + type + "/";
        this.spread = spread;
        this.setId(++id - 1);
        WorkspaceWindow.setUpdated(true);
        this.isLineSegment = true;
    }

    public View getView() {
        return this.view;
    }

    public void setView(View view) {
        this.view = view;
    }

    public Spread getSpread() {
        return this.spread;
    }

    public boolean contains(Point2D point) {
        return this.view.contains(point);
    }

    @Override
    public JPanel createElementViewPanel() throws NoWayToShowException {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout(5, 5));
        Image image = new ImageCropper(this).crop();
        JLabel label = new JLabel();
        if (this.centermode) {
            label.setHorizontalAlignment(0);
        }
        ImageIcon icon = new ImageIcon(image);
        label.setIcon(icon);
        panel.add(label);
        return panel;
    }

    @Override
    public JPanel createElementViewPanel(int width, int height) throws NoWayToShowException {
        JPanel panel = new JPanel();
        Image origImage = this.getSpread().getImage();
        BufferedImage bufferedOrigImage = new BufferedImage(origImage.getWidth(null), origImage.getHeight(null), 1);
        Graphics g = bufferedOrigImage.getGraphics();
        g.drawImage(origImage, 0, 0, null);
        View view = this.getView();
        boolean tmp = view.isSelected();
        view.setIsEmphasized(true);
        view.draw((Graphics2D)g);
        view.setIsEmphasized(tmp);
        Image croppedImage = new ImageCropper((Image)bufferedOrigImage, this).crop();
        JLabel label = new JLabel();
        if (this.centermode) {
            label.setHorizontalAlignment(0);
        }
        ImageIcon icon = new ImageIcon(croppedImage);
        label.setIcon(icon);
        panel.setLayout(new BorderLayout());
        panel.add((Component)label, "Center");
        return panel;
    }

    public JPanel createElementViewPanelForLocalView() {
        JPanel panel = new JPanel();
        boolean noListner = false;
        Image croppedImage = null;
        File imageFile = this.getSpread().getImageFile();
        Image origImage = this.getSpread().getImage();
        if (imageFile.exists() && origImage != null) {
            BufferedImage bufferedOrigImage = new BufferedImage(origImage.getWidth(null), origImage.getHeight(null), 1);
            Graphics g = bufferedOrigImage.getGraphics();
            g.drawImage(origImage, 0, 0, null);
            View view = this.getView();
            boolean tmp = view.isSelected();
            view.setIsEmphasized(true);
            view.draw((Graphics2D)g);
            view.setIsEmphasized(tmp);
            croppedImage = new ImageCropper((Image)bufferedOrigImage, this).cropForLocalView();
        } else if (!imageFile.exists()) {
            noListner = true;
            try {
                croppedImage = ImageIO.read(new File("./icons/no_image_found.png"));
            }
            catch (IOException e) {
                System.out.println("Failed to generate error message image! In Region.java");
            }
        } else {
            System.out.println("Failed to load the image file: " + imageFile.toString());
            return null;
        }
        JLabel label = new JLabel();
        if (this.centermode) {
            label.setHorizontalAlignment(0);
        }
        ImageIcon icon = new ImageIcon(croppedImage);
        label.setIcon(icon);
        panel.setLayout(new BorderLayout());
        panel.add((Component)label, "Center");
        if (!noListner) {
            panel.addMouseListener(new elementViewPanelListener(panel, this));
        }
        return panel;
    }

    public void setCentermode(boolean centermode) {
        this.centermode = centermode;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public void setProtection(String protection) {
        this.protection = protection;
    }

    public String isProtected() {
        return this.protection;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public Rectangle getRectangle() {
        return this.view.getRectangle();
    }

    public List<Point2D> getPoints() {
        return this.points;
    }

    public Point getCenterPoint() {
        int x = (int)this.getRectangle().getCenterX();
        int y = (int)this.getRectangle().getCenterY();
        return new Point(x, y);
    }

    public Point getCornerPoint() {
        int x = (int)this.getRectangle().getX();
        int y = (int)this.getRectangle().getY();
        return new Point(x, y);
    }

    @Override
    public String createURI() {
        return URICreator.createURI(this);
    }

    @Override
    public String getTypeString() {
        return this.view.getTypeString();
    }

    public boolean isLineSegment() {
        return this.isLineSegment;
    }

    @Override
    public void jump() {
        SpreadJumpAction.jumpToMarkup(this);
    }

    @Override
    public void openNewWindow() {
        SpreadOpenAction.openMarkup(this);
    }

    @Override
    public String toString() {
        return String.valueOf(this.view.getTitle()) + ": " + this.uri;
    }

    public String getTypeStringForDisplay() {
        return this.view.getTypeStringForDisplay();
    }

    @Override
    public String getTimeZone() {
        return this.timeZone;
    }

    @Override
    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }
}

