/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.menu;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import smart_gs.logical.Preference;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.util.CanonicalPathString;

public class BrowserSettingDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JLabel jLabel = null;
    private JTextField browserPath = null;
    private JButton selectButton = null;
    private JButton okButton = null;
    private JButton cancelButton = null;
    private JDialog jDialog;

    public BrowserSettingDialog(Frame owner) {
        super(owner, true);
        this.initialize();
        this.jDialog = this;
    }

    private void initialize() {
        this.setSize(555, 108);
        this.setContentPane(this.getJContentPane());
        this.setTitle("Select Web Browser");
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jLabel = new JLabel();
            this.jLabel.setBounds(new Rectangle(14, 11, 86, 16));
            this.jLabel.setText("Web Browser");
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(null);
            this.jContentPane.add((Component)this.jLabel, null);
            this.jContentPane.add((Component)this.getBrowserPath(), null);
            this.jContentPane.add((Component)this.getSelectButton(), null);
            this.jContentPane.add((Component)this.getOkButton(), null);
            this.jContentPane.add((Component)this.getCancelButton(), null);
        }
        return this.jContentPane;
    }

    private JTextField getBrowserPath() {
        if (this.browserPath == null) {
            this.browserPath = new JTextField();
            this.browserPath.setBounds(new Rectangle(105, 12, 308, 20));
            if (Preference.getInstance().getBrowser() != null) {
                this.browserPath.setText(Preference.getInstance().getBrowser());
            }
        }
        return this.browserPath;
    }

    private JButton getSelectButton() {
        if (this.selectButton == null) {
            this.selectButton = new JButton();
            this.selectButton.setText("select files...");
            this.selectButton.setBounds(new Rectangle(418, 12, 116, 20));
            this.selectButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JFileChooser chooser = new JFileChooser();
                    int returnVal = chooser.showOpenDialog(WorkspaceWindow.getInstance());
                    try {
                        if (returnVal == 0) {
                            File file = chooser.getSelectedFile();
                            BrowserSettingDialog.this.browserPath.setText(CanonicalPathString.get(file));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
        return this.selectButton;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton();
            this.okButton.setBounds(new Rectangle(168, 42, 100, 20));
            this.okButton.setText("OK");
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String browser = BrowserSettingDialog.this.browserPath.getText();
                    if (browser != null) {
                        Preference.getInstance().setBrowser(browser);
                    }
                    BrowserSettingDialog.this.jDialog.setVisible(false);
                }
            });
        }
        return this.okButton;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setBounds(new Rectangle(281, 42, 100, 20));
            this.cancelButton.setText("Cancel");
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BrowserSettingDialog.this.jDialog.setVisible(false);
                }
            });
        }
        return this.cancelButton;
    }
}

