/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.menu;

import java.awt.Color;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import smart_gs.drawing_tool.state.UniSelectedState;
import smart_gs.drawing_tool.view.MarkerView;
import smart_gs.drawing_tool.view.MemoPadView;
import smart_gs.image_search.GSSearchEngine;
import smart_gs.image_search.logical.TextType;
import smart_gs.logical.Preference;
import smart_gs.menu.BrowserSettingDialog;
import smart_gs.menu.DirectorySettingWindow;
import smart_gs.menu.EditorSettingDialog;
import smart_gs.menu.IDATNamesSetting;
import smart_gs.menu.action.BookmarkChangeDefaultSizeAction;
import smart_gs.menu.action.ChangeTextTypeAction;
import smart_gs.menu.action.ChangeUserNameAction;
import smart_gs.menu.action.MarkerChangeDefaultBreadthAction;
import smart_gs.menu.action.MarkerChangeDefaultColorAction;
import smart_gs.menu.action.MemoPadChangeDefaultColorAction;
import smart_gs.menu.action.RectangleMoveAction;
import smart_gs.swingui.AbstractGSWindow;
import smart_gs.swingui.WorkspaceWindow;
import webdav.preference.ProxySetting;
import webdav.preference.WebDavSetting;

public class PreferenceMenu
extends JMenu {
    public PreferenceMenu(String title, AbstractGSWindow window) {
        super(title);
        JMenuItem userName = new JMenuItem("User Name");
        userName.addActionListener(new ChangeUserNameAction());
        this.add(userName);
        JMenuItem IDATNamesSetting2 = new JMenuItem("IDAT Names");
        IDATNamesSetting2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IDATNamesSetting iDATNamesSetting = new IDATNamesSetting((Frame)WorkspaceWindow.getInstance(), true);
                iDATNamesSetting.setLocationRelativeTo(null);
                iDATNamesSetting.setVisible(true);
            }
        });
        this.add(IDATNamesSetting2);
        JMenu imageSearchEngine = new JMenu("Image Search Engine");
        boolean isExternalEngine = GSSearchEngine.getInstance().isUseExternalEngine();
        JRadioButtonMenuItem externalEngine = new JRadioButtonMenuItem("External", isExternalEngine);
        externalEngine.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GSSearchEngine.getInstance().setUseExternalEngine(true);
            }
        });
        JRadioButtonMenuItem internalEngine = new JRadioButtonMenuItem("Internal", !isExternalEngine);
        internalEngine.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GSSearchEngine.getInstance().setUseExternalEngine(false);
            }
        });
        ButtonGroup imageSearchEngineGroup = new ButtonGroup();
        imageSearchEngineGroup.add(externalEngine);
        imageSearchEngineGroup.add(internalEngine);
        imageSearchEngine.add(externalEngine);
        imageSearchEngine.add(internalEngine);
        this.add(imageSearchEngine);
        JMenu imageSearchType = new JMenu("Image Search Type in Dictionary");
        String type = Preference.getInstance().getSearchImageDictionaryLogic();
        boolean isType1 = false;
        boolean isType2 = false;
        boolean isType3 = false;
        if (type.equals("0")) {
            isType1 = true;
        } else if (type.equals("1")) {
            isType2 = true;
        } else if (type.equals("2")) {
            isType3 = true;
        } else {
            isType1 = true;
        }
        JRadioButtonMenuItem type1 = new JRadioButtonMenuItem("Type1", isType1);
        type1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Preference.getInstance().setSearchImageDictionaryLogic("0");
            }
        });
        JRadioButtonMenuItem type2 = new JRadioButtonMenuItem("Type2", isType2);
        type2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Preference.getInstance().setSearchImageDictionaryLogic("1");
            }
        });
        JRadioButtonMenuItem type3 = new JRadioButtonMenuItem("Type3", isType3);
        type3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Preference.getInstance().setSearchImageDictionaryLogic("2");
            }
        });
        ButtonGroup imageSearchTypeGroup = new ButtonGroup();
        imageSearchTypeGroup.add(type1);
        imageSearchTypeGroup.add(type2);
        imageSearchTypeGroup.add(type3);
        imageSearchType.add(type1);
        imageSearchType.add(type2);
        imageSearchType.add(type3);
        this.add(imageSearchType);
        JMenu textType = new JMenu("Text Type");
        JRadioButtonMenuItem horizontal = new JRadioButtonMenuItem("Horizontal", TextType.isHorizontal());
        horizontal.addActionListener(new ChangeTextTypeAction(0));
        JRadioButtonMenuItem vertical = new JRadioButtonMenuItem("Vertical", !TextType.isHorizontal());
        vertical.addActionListener(new ChangeTextTypeAction(1));
        ButtonGroup textTypeGroup = new ButtonGroup();
        textTypeGroup.add(horizontal);
        textTypeGroup.add(vertical);
        textType.add(horizontal);
        textType.add(vertical);
        this.add(textType);
        JMenuItem maxSearchNum = new JMenuItem("Search Size Bound");
        this.add(maxSearchNum);
        maxSearchNum.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String sizeStr = JOptionPane.showInputDialog("Input Max Found Size");
                if (sizeStr == null) {
                    return;
                }
                try {
                    int size = Integer.parseInt(sizeStr);
                    GSSearchEngine.getInstance().setMaxFound(size);
                }
                catch (NumberFormatException nfe) {
                    nfe.printStackTrace();
                }
            }
        });
        JMenu markupMenu = new JMenu("Markup");
        JMenu markupMove = new JMenu("Movability");
        boolean markupMovability = UniSelectedState.getInstance().getMarkupMovability();
        JRadioButtonMenuItem move = new JRadioButtonMenuItem("Movable", markupMovability);
        JRadioButtonMenuItem notMove = new JRadioButtonMenuItem("UnMovable", !markupMovability);
        ButtonGroup recGroup = new ButtonGroup();
        recGroup.add(move);
        recGroup.add(notMove);
        markupMove.add(move);
        markupMove.add(notMove);
        markupMenu.add(markupMove);
        move.addActionListener(new RectangleMoveAction(true));
        notMove.addActionListener(new RectangleMoveAction(false));
        this.add(markupMenu);
        JMenu memoPadDefaultColor = new JMenu("MemoPad Default Color");
        Color memoPad_dc = MemoPadView.stringToColor(Preference.getInstance().getMemoPadColor());
        JRadioButtonMenuItem memoPad_yellow = new JRadioButtonMenuItem("Yellow", memoPad_dc == MemoPadView.MEMOPAD_YELLOW);
        JRadioButtonMenuItem memoPad_cyan = new JRadioButtonMenuItem("Cyan", memoPad_dc == MemoPadView.MEMOPAD_CYAN);
        JRadioButtonMenuItem memoPad_magenta = new JRadioButtonMenuItem("Magenta", memoPad_dc == MemoPadView.MEMOPAD_MAGENTA);
        JRadioButtonMenuItem memoPad_green = new JRadioButtonMenuItem("Green", memoPad_dc == MemoPadView.MEMOPAD_GREEN);
        ButtonGroup memoPadColorGroup = new ButtonGroup();
        memoPadColorGroup.add(memoPad_yellow);
        memoPadColorGroup.add(memoPad_cyan);
        memoPadColorGroup.add(memoPad_magenta);
        memoPadColorGroup.add(memoPad_green);
        memoPadDefaultColor.add(memoPad_yellow);
        memoPadDefaultColor.add(memoPad_cyan);
        memoPadDefaultColor.add(memoPad_magenta);
        memoPadDefaultColor.add(memoPad_green);
        memoPad_yellow.addActionListener(new MemoPadChangeDefaultColorAction(MemoPadView.MEMOPAD_YELLOW));
        memoPad_cyan.addActionListener(new MemoPadChangeDefaultColorAction(MemoPadView.MEMOPAD_CYAN));
        memoPad_magenta.addActionListener(new MemoPadChangeDefaultColorAction(MemoPadView.MEMOPAD_MAGENTA));
        memoPad_green.addActionListener(new MemoPadChangeDefaultColorAction(MemoPadView.MEMOPAD_GREEN));
        markupMenu.add(memoPadDefaultColor);
        JMenu markerDefaultColor = new JMenu("Marker Default Color");
        Color marker_dc = MarkerView.stringToColor(Preference.getInstance().getMarkerColor());
        JRadioButtonMenuItem marker_yellow = new JRadioButtonMenuItem("Yellow", marker_dc == MarkerView.MARKER_YELLOW);
        JRadioButtonMenuItem marker_cyan = new JRadioButtonMenuItem("Cyan", marker_dc == MarkerView.MARKER_CYAN);
        JRadioButtonMenuItem marker_magenta = new JRadioButtonMenuItem("Magenta", marker_dc == MarkerView.MARKER_MAGENTA);
        JRadioButtonMenuItem marker_green = new JRadioButtonMenuItem("Green", marker_dc == MarkerView.MARKER_GREEN);
        ButtonGroup markerColorGroup = new ButtonGroup();
        markerColorGroup.add(marker_yellow);
        markerColorGroup.add(marker_cyan);
        markerColorGroup.add(marker_magenta);
        markerColorGroup.add(marker_green);
        markerDefaultColor.add(marker_yellow);
        markerDefaultColor.add(marker_cyan);
        markerDefaultColor.add(marker_magenta);
        markerDefaultColor.add(marker_green);
        marker_yellow.addActionListener(new MarkerChangeDefaultColorAction(MarkerView.MARKER_YELLOW));
        marker_cyan.addActionListener(new MarkerChangeDefaultColorAction(MarkerView.MARKER_CYAN));
        marker_magenta.addActionListener(new MarkerChangeDefaultColorAction(MarkerView.MARKER_MAGENTA));
        marker_green.addActionListener(new MarkerChangeDefaultColorAction(MarkerView.MARKER_GREEN));
        markupMenu.add(markerDefaultColor);
        JMenuItem markerDefaultBreadth = new JMenuItem("Marker Default Breadth");
        markerDefaultBreadth.addActionListener(new MarkerChangeDefaultBreadthAction(window));
        markupMenu.add(markerDefaultBreadth);
        JMenu bookmarkDefaultSize = new JMenu("Bookmark Default Size");
        double ds = new Double(Preference.getInstance().getBookmarkSize());
        JRadioButtonMenuItem huge = new JRadioButtonMenuItem("150%", ds == 1.5);
        JRadioButtonMenuItem large = new JRadioButtonMenuItem("125%", ds == 1.25);
        JRadioButtonMenuItem normal = new JRadioButtonMenuItem("100%", ds == 1.0);
        JRadioButtonMenuItem small = new JRadioButtonMenuItem("75%", ds == 0.75);
        JRadioButtonMenuItem tiny = new JRadioButtonMenuItem("50%", ds == 0.5);
        ButtonGroup bookmarkSizeGroup = new ButtonGroup();
        bookmarkSizeGroup.add(huge);
        bookmarkSizeGroup.add(large);
        bookmarkSizeGroup.add(normal);
        bookmarkSizeGroup.add(small);
        bookmarkSizeGroup.add(tiny);
        bookmarkDefaultSize.add(huge);
        bookmarkDefaultSize.add(large);
        bookmarkDefaultSize.add(normal);
        bookmarkDefaultSize.add(small);
        bookmarkDefaultSize.add(tiny);
        huge.addActionListener(new BookmarkChangeDefaultSizeAction(1.5));
        large.addActionListener(new BookmarkChangeDefaultSizeAction(1.25));
        normal.addActionListener(new BookmarkChangeDefaultSizeAction(1.0));
        small.addActionListener(new BookmarkChangeDefaultSizeAction(0.75));
        tiny.addActionListener(new BookmarkChangeDefaultSizeAction(0.5));
        markupMenu.add(bookmarkDefaultSize);
        JMenu resourceBasketDefaultSaveOption = new JMenu("Resource Basket Default Save Option");
        boolean dcbv = new Boolean(Preference.getInstance().getResourceBasketSaveOption());
        JRadioButtonMenuItem saveBasket = new JRadioButtonMenuItem("Save", dcbv);
        saveBasket.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Preference.getInstance().setResourceBasketSaveOption("true");
            }
        });
        JRadioButtonMenuItem deleteBasket = new JRadioButtonMenuItem("Do not save", !dcbv);
        saveBasket.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Preference.getInstance().setResourceBasketSaveOption("false");
            }
        });
        ButtonGroup basketDefaultSaveOptionGroup = new ButtonGroup();
        basketDefaultSaveOptionGroup.add(saveBasket);
        basketDefaultSaveOptionGroup.add(deleteBasket);
        resourceBasketDefaultSaveOption.add(saveBasket);
        resourceBasketDefaultSaveOption.add(deleteBasket);
        this.add(resourceBasketDefaultSaveOption);
        JMenuItem setDirectoryPath = new JMenuItem("Data Directories & Files");
        setDirectoryPath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DirectorySettingWindow.getInstance().setVisible(true);
            }
        });
        this.add(setDirectoryPath);
        JMenuItem setWebDavSetting = new JMenuItem("WebDAV");
        setWebDavSetting.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebDavSetting webDavSetting = new WebDavSetting((Frame)WorkspaceWindow.getInstance(), true);
                webDavSetting.setLocationRelativeTo(null);
                webDavSetting.setVisible(true);
            }
        });
        this.add(setWebDavSetting);
        JMenuItem setProxySetting = new JMenuItem("Proxy");
        setProxySetting.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProxySetting proxySetting = new ProxySetting((Frame)WorkspaceWindow.getInstance(), true);
                proxySetting.setLocationRelativeTo(null);
                proxySetting.setVisible(true);
            }
        });
        this.add(setProxySetting);
        JMenuItem setWebBrowser = new JMenuItem("Web Browser");
        setWebBrowser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BrowserSettingDialog browserSettingDialog = new BrowserSettingDialog(WorkspaceWindow.getInstance());
                browserSettingDialog.setLocationRelativeTo(null);
                browserSettingDialog.setVisible(true);
            }
        });
        this.add(setWebBrowser);
        JMenuItem setEditor = new JMenuItem("Editor");
        setEditor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorSettingDialog editorSettingDialog = new EditorSettingDialog(WorkspaceWindow.getInstance());
                editorSettingDialog.setLocationRelativeTo(null);
                editorSettingDialog.setVisible(true);
            }
        });
        this.add(setEditor);
    }
}

