/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.menu;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import smart_gs.dictionary.DictionaryDialog;
import smart_gs.drawing_tool.drawing_mode.BookmarkMode;
import smart_gs.drawing_tool.drawing_mode.DefaultDrawingMode;
import smart_gs.drawing_tool.drawing_mode.EraserMode;
import smart_gs.drawing_tool.drawing_mode.MarkerMode;
import smart_gs.drawing_tool.drawing_mode.MemoPadMode;
import smart_gs.drawing_tool.drawing_mode.PolygonMode;
import smart_gs.drawing_tool.drawing_mode.RectangleMode;
import smart_gs.drawing_tool.state.DefaultState;
import smart_gs.logical.GSResource;
import smart_gs.logical.ResourceBasket;
import smart_gs.logical.SpreadTree;
import smart_gs.menu.action.ResourceListAction;
import smart_gs.swingui.AbstractGSWindow;
import smart_gs.swingui.ResourceBasketsFrame;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.swingui.toolbar.ImageToolBar;

public class ToolMenu
extends JMenu
implements ActionListener {
    private JMenuItem select;
    private JMenuItem eraser;
    private JMenuItem rectangle;
    private JMenuItem marker;
    private JMenuItem polygon;
    private JMenuItem memopad;
    private JMenu bookmark;
    private JMenuItem insertBookmark;
    private JMenuItem bookmarkList;
    private JMenuItem resourceBasket;
    private JMenuItem zoomIn;
    private JMenuItem zoomOut;
    private JMenuItem fullSize;
    private JMenuItem fitWidth;
    private JMenuItem fitHeight;
    private JMenu showRegion;
    private AbstractGSWindow parent;
    private JMenuItem allRegions;
    private JMenuItem protectedRegions;
    private JMenuItem noRegions;
    private JMenuItem protectAllRegions;
    private JMenuItem releaseAllRegions;

    public ToolMenu(String title, AbstractGSWindow parent) {
        super(title);
        this.parent = parent;
        this.select = new JMenuItem("Select", new ImageIcon("./icons/select.gif"));
        this.select.addActionListener(this);
        this.add(this.select);
        this.eraser = new JMenuItem("Eraser", new ImageIcon("./icons/delete.gif"));
        this.eraser.addActionListener(this);
        this.add(this.eraser);
        this.addSeparator();
        this.rectangle = new JMenuItem("Rectangle");
        this.rectangle.addActionListener(this);
        this.add(this.rectangle);
        this.marker = new JMenuItem("Marker");
        this.marker.addActionListener(this);
        this.add(this.marker);
        this.polygon = new JMenuItem("Polygon");
        this.polygon.addActionListener(this);
        this.add(this.polygon);
        this.memopad = new JMenuItem("MemoPad");
        this.memopad.addActionListener(this);
        this.add(this.memopad);
        this.bookmark = new JMenu("Bookmark");
        this.add(this.bookmark);
        this.insertBookmark = new JMenuItem("Insert");
        this.insertBookmark.addActionListener(this);
        this.bookmark.add(this.insertBookmark);
        this.bookmarkList = new JMenuItem("List");
        this.bookmarkList.addActionListener(this);
        this.bookmark.add(this.bookmarkList);
        this.resourceBasket = new JMenuItem("Resource Basket");
        this.resourceBasket.addActionListener(this);
        this.add(this.resourceBasket);
        this.addSeparator();
        this.zoomIn = new JMenuItem("Zoom in", new ImageIcon("./icons/zoom_in.gif"));
        this.zoomIn.addActionListener(this);
        this.add(this.zoomIn);
        this.zoomOut = new JMenuItem("Zoom out", new ImageIcon("./icons/zoom_out.gif"));
        this.zoomOut.addActionListener(this);
        this.add(this.zoomOut);
        this.fullSize = new JMenuItem("Full Size");
        this.fullSize.addActionListener(this);
        this.add(this.fullSize);
        this.fitWidth = new JMenuItem("Fit Width");
        this.fitWidth.addActionListener(this);
        this.add(this.fitWidth);
        this.fitHeight = new JMenuItem("Fit Height");
        this.fitHeight.addActionListener(this);
        this.add(this.fitHeight);
        this.addSeparator();
        this.showRegion = new JMenu("Show Region");
        this.add(this.showRegion);
        this.allRegions = new JMenuItem("All Regions");
        this.allRegions.addActionListener(this);
        this.add(this.allRegions);
        this.protectedRegions = new JMenuItem("Protected Regions");
        this.protectedRegions.addActionListener(this);
        this.add(this.protectedRegions);
        this.noRegions = new JMenuItem("No Region");
        this.noRegions.addActionListener(this);
        this.add(this.noRegions);
        this.showRegion.add(this.allRegions);
        this.showRegion.add(this.protectedRegions);
        this.showRegion.add(this.noRegions);
        this.protectAllRegions = new JMenuItem("Protect All Regions");
        this.protectAllRegions.addActionListener(this);
        this.add(this.protectAllRegions);
        this.releaseAllRegions = new JMenuItem("Release All Reagions");
        this.releaseAllRegions.addActionListener(this);
        this.add(this.releaseAllRegions);
        this.addSeparator();
        JMenuItem test = new JMenuItem("Dictionary");
        test.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DictionaryDialog dictionaryDialog = new DictionaryDialog((Frame)WorkspaceWindow.getInstance(), "Dictionary", false, 0);
                dictionaryDialog.setVisible(true);
            }
        });
        this.add(test);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.select)) {
            DefaultState.getInstance().setMode(DefaultDrawingMode.getInstance());
            ImageToolBar.setModeListItem(ImageToolBar.modelistarray[ImageToolBar.modeNone]);
        } else if (e.getSource().equals(this.rectangle)) {
            DefaultState.getInstance().setMode(RectangleMode.getInstance());
            ImageToolBar.setModeListItem(ImageToolBar.modelistarray[ImageToolBar.modeRectangle]);
        } else if (e.getSource().equals(this.marker)) {
            DefaultState.getInstance().setMode(MarkerMode.getInstance());
            ImageToolBar.setModeListItem(ImageToolBar.modelistarray[ImageToolBar.modeMarker]);
        } else if (e.getSource().equals(this.polygon)) {
            DefaultState.getInstance().setMode(PolygonMode.getInstance());
            ImageToolBar.setModeListItem(ImageToolBar.modelistarray[ImageToolBar.modePolygon]);
        } else if (e.getSource().equals(this.memopad)) {
            DefaultState.getInstance().setMode(MemoPadMode.getInstance());
            ImageToolBar.setModeListItem(ImageToolBar.modelistarray[ImageToolBar.modeMemoPad]);
        } else if (e.getSource().equals(this.insertBookmark)) {
            DefaultState.getInstance().setMode(BookmarkMode.getInstance());
            ImageToolBar.setModeListItem(ImageToolBar.modelistarray[ImageToolBar.modeBookmark]);
        } else if (e.getSource().equals(this.bookmarkList)) {
            List<GSResource> bookmarks = SpreadTree.getInstance().getBookmarks();
            new ResourceListAction(new ResourceBasket(bookmarks, "Bookmark"), true).actionPerformed(e);
            this.parent.repaint();
        } else if (e.getSource().equals(this.resourceBasket)) {
            ResourceBasketsFrame.getInstance().showResourceBasketFrame();
        } else if (e.getSource().equals(this.zoomIn)) {
            this.parent.getSpreadCanvas().zoomIn();
        } else if (e.getSource().equals(this.zoomOut)) {
            this.parent.getSpreadCanvas().zoomOut();
        } else if (e.getSource().equals(this.fullSize)) {
            this.parent.getSpreadCanvas().fullSize();
        } else if (e.getSource().equals(this.fitWidth)) {
            this.parent.getSpreadCanvas().fitWidth();
        } else if (e.getSource().equals(this.fitHeight)) {
            this.parent.getSpreadCanvas().fitHeight();
        } else if (e.getSource().equals(this.eraser)) {
            DefaultState.getInstance().setMode(EraserMode.getInstance());
            ImageToolBar.setModeListItem(ImageToolBar.modelistarray[ImageToolBar.modeEraser]);
            this.parent.repaint();
        } else if (e.getSource().equals(this.allRegions)) {
            ImageToolBar.setShowRegionItem(ImageToolBar.showregionarray[ImageToolBar.showAll]);
            this.parent.getSpreadCanvas().getSpread().changeShowRegion(0);
            this.parent.repaint();
        } else if (e.getSource().equals(this.protectedRegions)) {
            ImageToolBar.setShowRegionItem(ImageToolBar.showregionarray[ImageToolBar.showProtected]);
            this.parent.getSpreadCanvas().getSpread().changeShowRegion(1);
            this.parent.repaint();
        } else if (e.getSource().equals(this.noRegions)) {
            ImageToolBar.setShowRegionItem(ImageToolBar.showregionarray[ImageToolBar.showNo]);
            this.parent.getSpreadCanvas().getSpread().changeShowRegion(2);
            this.parent.repaint();
        } else if (e.getSource().equals(this.protectAllRegions)) {
            this.parent.getSpreadCanvas().protectAllRegions();
        } else if (e.getSource().equals(this.releaseAllRegions)) {
            this.parent.getSpreadCanvas().releaseAllRegions();
        }
    }
}

