/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.reasoning_web.desktop.logical;

import javax.swing.JLabel;
import javax.swing.JPanel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import reasoning_web.logical.inter_face.NoWayToShowException;
import smart_gs.GSVersion;
import smart_gs.logical.StandardTextDocument;
import smart_gs.logical.URICreator;
import smart_gs.logical.XML2ResourceConverter;
import smart_gs.reasoning_web.URIBearer;
import smart_gs.reasoning_web.desktop.logical.DeskTopFolder;
import smart_gs.reasoning_web.desktop.logical.DesktopElement;
import smart_gs.reasoning_web.desktop.swingui.ReasoningWebDesktop;
import smart_gs.reasoning_web.desktop.swingui.view.DesktopElementView;
import smart_gs.reasoning_web.desktop.swingui.view.ShortCutView;
import smart_gs.reasoning_web.logical.GS_RWElement;
import smart_gs.reasoning_web.logical.XML2RWElementConverter;

public class ShortCut
extends DesktopElement
implements URIBearer {
    private GS_RWElement resource;
    private String uri;
    private String originalURI;
    private String oldVersionURI;
    private String version;
    private String resourceURI;

    public ShortCut() {
        this.setURIs();
        this.setVersion(GSVersion.getVersion());
    }

    public ShortCut(GS_RWElement resource, String name, StandardTextDocument memo, String uri, String originalURI, String version) {
        super(ReasoningWebDesktop.getInstance().getRootFolder(), name, memo);
        this.resource = resource;
        this.setName(this.name);
        this.setURIs(uri, originalURI);
        this.setVersion(version);
    }

    public ShortCut(GS_RWElement resource, String name, StandardTextDocument memo) {
        super(ReasoningWebDesktop.getInstance().getRootFolder(), name, memo);
        this.resource = resource;
        this.setName(this.name);
        this.setURIs();
        memo.setName(this.name);
    }

    @Override
    public DesktopElementView createView() {
        return new ShortCutView();
    }

    @Override
    public void open() {
        this.resource.show();
    }

    public void setParentFolder(DeskTopFolder parent) {
        this.parent = parent;
    }

    @Override
    public Element createXMLElement(Document document) {
        Element element = document.createElement("shortcut");
        element.setAttribute("name", this.name);
        element.setAttribute("uri", this.getURI());
        element.setAttribute("originalURI", this.originalURI);
        element.setAttribute("oldVersionURI", this.getOldVersionURI());
        element.setAttribute("version", this.version);
        element.setAttribute("resourceURI", this.resourceURI);
        if (this.resource != null) {
            element.appendChild(this.resource.createXMLElement(document));
        }
        element.appendChild(this.memo.createXMLElement(document));
        return element;
    }

    public void setResource(GS_RWElement resource) {
        this.resource = resource;
        if (resource != null) {
            this.resourceURI = resource.getURI();
        }
    }

    public static ShortCut restore(Element element) {
        String name = element.getAttribute("name");
        String uri = element.getAttribute("uri");
        String originalURI = element.getAttribute("originalURI");
        String oldVersionURI = element.getAttribute("oldVersionURI");
        String version = element.getAttribute("version");
        String source = element.getAttribute("source");
        String resourceURI = element.getAttribute("resourceURI");
        ShortCut shortcut = new ShortCut();
        shortcut.setName(name);
        shortcut.setOldVersionURI(oldVersionURI);
        shortcut.setVersion(version);
        shortcut.setString(source);
        shortcut.setResourceURI(resourceURI);
        NodeList list = element.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1) {
                Element elem = (Element)list.item(i);
                if (elem.getNodeName().equals("standardDocument")) {
                    StandardTextDocument memo = (StandardTextDocument)XML2ResourceConverter.convert(elem);
                    shortcut.setMemo(memo);
                } else {
                    GS_RWElement resource = XML2RWElementConverter.convert((Element)list.item(i));
                    if (resource == null) {
                        System.out.println("Error: specified resource is not found. Null-resource ShortCut is made for " + (Element)list.item(i));
                    } else {
                        shortcut.setResource(resource);
                    }
                }
            }
            ++i;
        }
        shortcut.setURIs(uri, originalURI);
        return shortcut;
    }

    public void setResourceURI(String resourceURI) {
        this.resourceURI = resourceURI;
    }

    @Override
    public JPanel createElementViewPanel() throws NoWayToShowException {
        throw new NoWayToShowException();
    }

    @Override
    public JPanel createElementViewPanel(int width, int height) throws NoWayToShowException {
        JPanel panel = new JPanel();
        panel.add(new JLabel("ShortCut"));
        panel.setSize(width, height);
        return panel;
    }

    @Override
    public String getURI() {
        return this.uri;
    }

    @Override
    public void show() {
        this.resource.show();
    }

    public GS_RWElement getResource() {
        return this.resource;
    }

    @Override
    public String createURI() {
        return URICreator.createURI(this);
    }

    @Override
    public String getTypeString() {
        return "shortcut";
    }

    @Override
    public void setURI(String uri) {
        this.uri = uri;
    }

    @Override
    public String getOriginalURI() {
        return this.originalURI;
    }

    @Override
    public void setOriginalURI(String originalURI) {
        this.originalURI = originalURI;
    }

    @Override
    public void setURIs(String uri, String originalURI) {
        URICreator.setURIs(this, uri, originalURI);
    }

    @Override
    public void setURIs() {
        this.uri = this.originalURI = URICreator.createURI(this);
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public String getOldVersionURI() {
        return this.oldVersionURI;
    }

    @Override
    public void setOldVersionURI(String oldVersionURI) {
        this.oldVersionURI = oldVersionURI;
    }
}

