/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.reasoning_web.logical;

import java.util.ArrayList;
import java.util.List;
import smart_gs.logical.GSResource;
import smart_gs.logical.URICreator;
import smart_gs.reasoning_web.logical.GSExplanatoryNote;

public class ExpNoteManager {
    private static ExpNoteManager singleton = new ExpNoteManager();
    private List<GSExplanatoryNote> notes = new ArrayList<GSExplanatoryNote>();

    private ExpNoteManager() {
    }

    public static ExpNoteManager getInstance() {
        return singleton;
    }

    public GSExplanatoryNote getExplanatoryNote(int id) {
        int i = 0;
        while (i < this.notes.size()) {
            if (this.notes.get(i).getId() == id) {
                return this.notes.get(i);
            }
            ++i;
        }
        return null;
    }

    public void addNote(GSExplanatoryNote note) {
        this.notes.add(note);
    }

    public GSResource getResource(String uri) {
        int i = 0;
        while (i < this.notes.size()) {
            if (this.notes.get(i).equals(uri)) {
                return this.notes.get(i);
            }
            GSResource segment = this.notes.get(i).getTextSegmentByURI(uri);
            if (segment != null) {
                return segment;
            }
            ++i;
        }
        return null;
    }

    public GSExplanatoryNote getExplanatoryNoteByTextSegmentURI(String uri) {
        String expNoteURI = this.extractExplanatoryNoteURIfromTextSegment(uri);
        int i = 0;
        while (i < this.notes.size()) {
            if (URICreator.getURIWithoutHeader(this.notes.get(i)).equals(expNoteURI)) {
                System.out.println("  return notes.get(" + i + ")");
                return this.notes.get(i);
            }
            ++i;
        }
        System.out.println("  return null");
        return null;
    }

    private String extractExplanatoryNoteURIfromTextSegment(String uri) {
        return uri.substring(uri.indexOf("^explanatory") + 1);
    }

    public List<GSExplanatoryNote> getNotes() {
        return this.notes;
    }

    public boolean has(GSExplanatoryNote note) {
        List<GSExplanatoryNote> notes = this.notes;
        for (GSExplanatoryNote n : notes) {
            if (n.getURI() != note.getURI()) continue;
            System.out.println(n.getURI());
            return true;
        }
        return false;
    }
}

