/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.reasoning_web.logical;

import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import reasoning_web.logical.Connection;
import reasoning_web.logical.ExplanatoryNote;
import reasoning_web.logical.ResourcePointer;
import smart_gs.logical.GSResource;
import smart_gs.logical.URISolver;
import smart_gs.logical.Zombie;
import smart_gs.reasoning_web.URIBearer;
import smart_gs.reasoning_web.logical.GSExplanatoryNote;
import smart_gs.reasoning_web.logical.GS_RWElement;
import smart_gs.reasoning_web.logical.GS_RWRepository;
import smart_gs.reasoning_web.swingui.view.ResourcePointerView;
import smart_gs.reasoning_web.swingui.view.View;
import smart_gs.util.Quadruple;

public class GSResourcePointer
extends ResourcePointer {
    protected View view = new ResourcePointerView(this);

    protected GSResourcePointer(GS_RWElement element) {
        super(element);
    }

    public View getView() {
        return this.view;
    }

    public ArrayList<Quadruple<Connection, GS_RWElement, GSExplanatoryNote, Integer>> getLocalViewInfo() {
        ArrayList<Quadruple<Connection, GS_RWElement, GSExplanatoryNote, Integer>> elements = new ArrayList<Quadruple<Connection, GS_RWElement, GSExplanatoryNote, Integer>>();
        int i = 0;
        while (i < this.connections.size()) {
            int peer_edge_type;
            ResourcePointer peer_pointer;
            Connection connection = (Connection)this.connections.get(i);
            ExplanatoryNote note = connection.getExplanatoryNote();
            int this_edge_type = connection.typeOfPointerInConnection(this);
            if (this_edge_type == 1) {
                peer_pointer = connection.getTargetPointer();
                peer_edge_type = 2;
            } else if (this_edge_type == 2) {
                peer_pointer = connection.getSourcePointer();
                peer_edge_type = 1;
            } else {
                peer_pointer = connection.getTargetPointer();
                peer_edge_type = 0;
            }
            elements.add(new Quadruple<Connection, GS_RWElement, GSExplanatoryNote, Integer>(connection, (GS_RWElement)peer_pointer.getRwElement(), (GSExplanatoryNote)note, new Integer(peer_edge_type)));
            ++i;
        }
        return elements;
    }

    public Element createXMLElement(Document document) {
        Element element = document.createElement("pointer");
        element.setAttribute("uri", ((GS_RWElement)this.rw_element).getURI());
        element.setAttribute("originalURI", ((URIBearer)((Object)this.rw_element)).getOriginalURI());
        element.setAttribute("x", String.valueOf(this.view.getRectangle().getX()));
        element.setAttribute("y", String.valueOf(this.view.getRectangle().getY()));
        element.setAttribute("width", String.valueOf(this.view.getRectangle().getWidth()));
        element.setAttribute("height", String.valueOf(this.view.getRectangle().getHeight()));
        if (this.name != "") {
            element.setAttribute("name", this.name);
        }
        return element;
    }

    public static GSResourcePointer restore(Element element) {
        GSResource resource;
        String uri = element.getAttribute("uri");
        double x = 300.0;
        double y = 300.0;
        String name = "";
        if (element.getAttribute("x") != "") {
            x = Double.parseDouble(element.getAttribute("x"));
        }
        if (element.getAttribute("y") != "") {
            y = Double.parseDouble(element.getAttribute("y"));
        }
        if (element.getAttribute("name") != "") {
            name = element.getAttribute("name");
        }
        if ((resource = URISolver.getResource(uri)) == null) {
            System.out.println(String.format("Error: resource %s is not found. Making a zombie for a resource pointer", uri));
            resource = new Zombie(uri);
        }
        if (GS_RWRepository.getInstance().isRegistered(resource)) {
            GSResourcePointer pointer = GS_RWRepository.getInstance().getResourcePointer(resource);
            pointer.view.setRectangle(x, y);
            pointer.setName(name);
            return pointer;
        }
        GSResourcePointer pointer = new GSResourcePointer(resource);
        pointer.view.setRectangle(x, y);
        pointer.setName(name);
        return pointer;
    }

    public String getURI() {
        return ((GS_RWElement)this.rw_element).getURI();
    }
}

