/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.reasoning_web.swingui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import smart_gs.logical.GSResource;
import smart_gs.reasoning_web.RootFolder;
import smart_gs.reasoning_web.desktop.logical.DeskTopFolder;
import smart_gs.reasoning_web.desktop.logical.DesktopElement;
import smart_gs.reasoning_web.desktop.swingui.FolderPanel;
import smart_gs.reasoning_web.desktop.swingui.ShortCutListPanel;
import smart_gs.reasoning_web.swingui.DeskTopToolbar;

public class DesktopPanel
extends JPanel {
    private DeskTopFolder rootFolder;
    private DeskTopFolder currentFolder;
    private FolderPanel mainPanel;
    private JScrollPane scrollPane = new JScrollPane();
    private JToolBar toolBar = new DeskTopToolbar();
    private ShortCutListPanel shortCutListPanel;

    public DesktopPanel() {
        this.currentFolder = this.rootFolder = RootFolder.getInstance();
        this.mainPanel = new FolderPanel(this.rootFolder);
        this.scrollPane.setViewportView(this.mainPanel);
        this.setLayout(new BorderLayout());
        this.shortCutListPanel = new ShortCutListPanel(this.currentFolder);
        JScrollPane leftPanel = new JScrollPane(this.shortCutListPanel);
        JSplitPane mainPanel = new JSplitPane(1, leftPanel, this.scrollPane);
        mainPanel.setDividerLocation(300);
        this.add((Component)mainPanel, "Center");
    }

    public DeskTopFolder getCurrentFolder() {
        return this.currentFolder;
    }

    public void setMainPanel(FolderPanel panel) {
        this.scrollPane.setViewportView(panel);
        this.mainPanel = panel;
        this.currentFolder = panel.getFolder();
        this.updateAll(this.currentFolder);
    }

    public void up() {
        FolderPanel panel = this.mainPanel;
        DeskTopFolder folder = panel.getFolder().getParent();
        if (folder != null) {
            this.setMainPanel(new FolderPanel(folder));
        }
    }

    public void upWithSelectedElements(Object[] elements) {
        FolderPanel panel = this.mainPanel;
        DeskTopFolder folder = panel.getFolder();
        DeskTopFolder parentFolder = panel.getFolder().getParent();
        if (parentFolder != null) {
            this.setMainPanel(new FolderPanel(parentFolder));
            int i = 0;
            while (i < elements.length) {
                DesktopElement element = (DesktopElement)elements[i];
                folder.remove(element);
                parentFolder.add(element);
                ++i;
            }
        }
    }

    public JToolBar getToolBar() {
        return this.toolBar;
    }

    public void initialize() {
        this.rootFolder.initialize();
        this.setMainPanel(new FolderPanel(this.rootFolder));
        this.updateAll(this.rootFolder);
        this.mainPanel.notifyChange();
    }

    public void updateAll() {
        this.shortCutListPanel.update();
    }

    public void updateAll(DeskTopFolder folder) {
        this.shortCutListPanel.update(folder);
    }

    public void setSelectedElement(DesktopElement selectedElement) {
        this.shortCutListPanel.setSelectedElement(selectedElement);
    }

    public DesktopElement getSelectedElement() {
        return this.shortCutListPanel.getSelectedElement();
    }

    public Object[] getSelectedElements() {
        return this.shortCutListPanel.getSelectedElements();
    }

    public GSResource getResource(String uri) {
        return this.rootFolder.getResource(uri);
    }
}

