/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.reasoning_web.swingui;

import java.awt.Component;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import reasoning_web.logical.Connection;
import smart_gs.logical.SmartDocument;
import smart_gs.reasoning_web.logical.GSExplanatoryNote;
import smart_gs.reasoning_web.logical.GS_RWElement;
import smart_gs.reasoning_web.swingui.LocalViewPanel;
import smart_gs.smleditor.swingui.GSEditorTextPane;
import smart_gs.swingui.ButtonFrame;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.util.Quadruple;

public class LocalViewFrame
extends ButtonFrame {
    private ArrayList<Quadruple<Connection, GS_RWElement, GSExplanatoryNote, Integer>> elements;
    private JPanel localViewPanel;
    private ArrayList<GSEditorTextPane> textPanes = new ArrayList();
    private ArrayList<SmartDocument> documents = new ArrayList();
    private ArrayList<JTextField> nameFields = new ArrayList();
    private ArrayList<Connection> connections = new ArrayList();
    public static final int HEIGHT = 200;
    public static final int WIDTH = 400;

    public LocalViewFrame(ArrayList<Quadruple<Connection, GS_RWElement, GSExplanatoryNote, Integer>> info) {
        super("", "Local View");
        this.elements = info;
        this.localViewPanel = new LocalViewPanel(this.elements, this);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.getVerticalScrollBar().setUnitIncrement(25);
        scrollPane.setViewportView(this.localViewPanel);
        this.getContentPane().add((Component)scrollPane, "Center");
        PointerInfo pointerInfo = MouseInfo.getPointerInfo();
        Point p = pointerInfo.getLocation();
        this.setLocation(p.x - 200 + 25, p.y - 200 + 33);
        this.validate();
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void ok() {
        this.notifyCurrentStateOfTextPane();
        this.dispose();
        WorkspaceWindow.getInstance().updateGUI();
    }

    @Override
    public void cancel() {
        this.dispose();
    }

    public void addTextPane(GSEditorTextPane textPane, JTextField nameField, Connection connection) {
        this.textPanes.add(textPane);
        this.documents.add(textPane.getSmartDocument());
        this.nameFields.add(nameField);
        this.connections.add(connection);
    }

    public void notifyCurrentStateOfTextPane() {
        int i = 0;
        while (i < this.textPanes.size()) {
            Connection connection = this.connections.get(i);
            GSEditorTextPane textPane = this.textPanes.get(i);
            String name = this.nameFields.get(i).getText();
            connection.setName(name);
            SmartDocument document = this.documents.get(i);
            document.setSource("<xml><html>" + textPane.getSource("body") + "</html></xml>");
            ++i;
        }
    }
}

