/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.smleditor.swingui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import smart_gs.current_text_search.SearchDialogManager;
import smart_gs.drawing_tool.SpreadCanvas;
import smart_gs.logical.IDAT;
import smart_gs.logical.Spread;
import smart_gs.logical.TextSegment;
import smart_gs.smleditor.swingui.FirstIDATPanel;
import smart_gs.smleditor.swingui.GSEditor;
import smart_gs.smleditor.swingui.GSEditorFrame;
import smart_gs.smleditor.swingui.GSEditorTextPane;
import smart_gs.smleditor.swingui.IDATPanel;
import smart_gs.smleditor.swingui.SecondIDATPanel;
import smart_gs.smleditor.swingui.ThirdIDATPanel;
import smart_gs.swingui.IDATNameInGSTabbedPaneManager;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.swingui.toolbar.GSEditorToolBar;
import sml_editor.swingui.EditorTextPane;
import sml_editor.swingui.GSHTMLEditorTextPane;

public class GSTabbedPane
extends JTabbedPane
implements ChangeListener {
    protected SpreadCanvas canvas;
    protected IDATPanel firstIDATPanel;
    protected IDATPanel secondIDATPanel;
    protected IDATPanel thirdIDATPanel;
    protected Spread spread;
    protected GSEditorFrame parent;

    public GSTabbedPane() {
        this.add(new JPanel());
    }

    public GSTabbedPane(GSEditorFrame parent, Spread spread) {
        this.parent = parent;
        this.spread = spread;
        this.canvas = new SpreadCanvas(spread, this);
        this.firstIDATPanel = new FirstIDATPanel(parent, spread.getFirstIDAT());
        this.secondIDATPanel = new SecondIDATPanel(parent, spread.getSecondIDAT());
        this.thirdIDATPanel = new ThirdIDATPanel(parent, spread.getThirdIDAT());
        this.addTab("Image", this.canvas);
        this.addTab(spread.getFirstIDATName(), this.firstIDATPanel);
        this.addTab(spread.getSecondIDATName(), this.secondIDATPanel);
        this.addTab(spread.getThirdIDATName(), this.thirdIDATPanel);
        TabTitleEditListener l = new TabTitleEditListener(this);
        this.addChangeListener(l);
        this.addMouseListener(l);
        this.addMouseListener(new GSTabbedPaneMouseAdapter(parent));
    }

    public SpreadCanvas getSpreadCanvas() {
        return this.canvas;
    }

    public void setSpread(Spread spread) {
        this.spread = spread;
        this.canvas.setSpread(spread);
        this.canvas.setGsTabbedPane(this);
        this.updateGUI(spread);
    }

    private void updateGUI(Spread spread) {
        GSEditor parent = (GSEditor)this.parent;
        GSTabbedPane oldTabbedPane = parent.tabbedPane;
        int selectedTab = this.getSelectedIndex();
        parent.setTitle("Editor: " + spread.getName());
        oldTabbedPane.removeAll();
        this.firstIDATPanel = new FirstIDATPanel((GSEditorFrame)parent, spread.getFirstIDAT());
        this.secondIDATPanel = new SecondIDATPanel(parent, spread.getSecondIDAT());
        this.thirdIDATPanel = new ThirdIDATPanel(parent, spread.getThirdIDAT());
        this.addTab("Image", this.canvas);
        this.addTab(spread.getFirstIDATName(), this.firstIDATPanel);
        this.addTab(spread.getSecondIDATName(), this.secondIDATPanel);
        this.addTab(spread.getThirdIDATName(), this.thirdIDATPanel);
        this.setSelectedIndex(selectedTab);
        TabTitleEditListener l = new TabTitleEditListener(this);
        this.addChangeListener(l);
        this.addMouseListener(l);
        this.addMouseListener(new GSTabbedPaneMouseAdapter(parent));
        parent.setURL(spread.getURI());
        parent.updateWindowListener();
    }

    public Spread getSpread() {
        return this.spread;
    }

    public Point getCornerPoint() {
        return this.canvas.getCornerPoint();
    }

    public void setPanelToShow(int type) {
        this.setSelectedIndex(type);
    }

    public void save() {
        if (this.firstIDATPanel != null) {
            this.firstIDATPanel.save();
        }
        if (this.secondIDATPanel != null) {
            this.secondIDATPanel.save();
        }
        if (this.thirdIDATPanel != null) {
            this.thirdIDATPanel.save();
        }
    }

    public void emphasize(String id) {
        this.firstIDATPanel.emphasize(id);
        this.secondIDATPanel.emphasize(id);
        this.thirdIDATPanel.emphasize(id);
    }

    public void emphasize(TextSegment segment) {
        String id = String.valueOf(segment.getId());
        int index = ((IDAT)segment.getDocument()).getType();
        this.setSelectedIndex(index - 1);
        this.emphasize(id);
    }

    public void emphasize(int idat_index, int start, int length) {
        switch (idat_index) {
            case 1: {
                this.firstIDATPanel.emphasize(start, length);
                break;
            }
            case 2: {
                this.secondIDATPanel.emphasize(start, length);
                break;
            }
            case 3: {
                this.thirdIDATPanel.emphasize(start, length);
                break;
            }
            default: {
                System.out.println("Error in emphasize(int idat_index, int start, int end) ");
            }
        }
    }

    public void updateText() {
        this.firstIDATPanel.updateText();
        this.secondIDATPanel.updateText();
        this.thirdIDATPanel.updateText();
    }

    public void clear() {
        if (this.firstIDATPanel != null) {
            this.firstIDATPanel.removeAll();
        }
        if (this.secondIDATPanel != null) {
            this.secondIDATPanel.removeAll();
        }
        if (this.secondIDATPanel != null) {
            this.secondIDATPanel.removeAll();
        }
        if (this.canvas != null) {
            this.canvas.clear();
            this.canvas = null;
        }
    }

    public boolean isAvailable() {
        return this.canvas != null && this.firstIDATPanel != null && this.secondIDATPanel != null && this.thirdIDATPanel != null;
    }

    public void updateFirstIDAT(String source) {
        this.firstIDATPanel.getTextPane().setSource(source);
    }

    public void updateSecondIDAT(String source) {
        this.secondIDATPanel.getTextPane().setSource(source);
    }

    public void updateThirdIDAT(String source) {
        this.thirdIDATPanel.getTextPane().setSource(source);
    }

    public String getFirstIDATSource() {
        return this.firstIDATPanel.getTextPane().getSource();
    }

    public String getSecondIDATSource() {
        return this.secondIDATPanel.getTextPane().getSource();
    }

    public String getThirdIDATSource() {
        return this.thirdIDATPanel.getTextPane().getSource();
    }

    public GSEditorTextPane getFirstIDAT() {
        return this.firstIDATPanel.getTextPane();
    }

    public GSEditorTextPane getSecondIDAT() {
        return this.secondIDATPanel.getTextPane();
    }

    public GSEditorTextPane getThirdIDAT() {
        return this.thirdIDATPanel.getTextPane();
    }

    public String getURI() {
        if (this.spread == null) {
            return null;
        }
        return this.spread.getURI();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Component comp;
        if (this.parent != null && (comp = this.getComponent(this.getSelectedIndex())) != null) {
            if (comp instanceof IDATPanel) {
                if (this.parent instanceof WorkspaceWindow) {
                    this.parent.setEditorTextPane(((IDATPanel)comp).getTextPane());
                } else if (this.parent instanceof GSEditor) {
                    this.parent.setEditorTextPane(((IDATPanel)comp).getTextPane());
                }
            } else if (!(this.parent instanceof WorkspaceWindow)) {
                boolean cfr_ignored_0 = this.parent instanceof GSEditor;
            }
        }
    }

    public void setCaret(int index) {
        IDATPanel panel = (IDATPanel)this.getSelectedComponent();
        GSHTMLEditorTextPane gsHTMLEditorTextPane = panel.getTextPane().getGSHTMLEditorTextPane();
        gsHTMLEditorTextPane.addFocusListener(new GSEditorFocusListener(gsHTMLEditorTextPane, index));
        panel.getTextPane().getGSHTMLEditorTextPane().requestFocus();
    }

    public GSEditorFrame getParentFrame() {
        return this.parent;
    }

    public void setEditorTextPane(EditorTextPane textPane) {
        int tabIndex = this.getSelectedIndex();
        if (tabIndex == this.indexOfComponent(this.firstIDATPanel)) {
            this.firstIDATPanel.setEditorTextPane(textPane);
        }
        if (tabIndex == this.indexOfComponent(this.secondIDATPanel)) {
            this.secondIDATPanel.setEditorTextPane(textPane);
        }
        if (tabIndex == this.indexOfComponent(this.thirdIDATPanel)) {
            this.thirdIDATPanel.setEditorTextPane(textPane);
        }
    }

    public GSEditorToolBar getGSEditorToolBar() {
        int tabIndex = this.getSelectedIndex();
        if (tabIndex == this.indexOfComponent(this.firstIDATPanel)) {
            return this.firstIDATPanel.getGSEditorToolBar();
        }
        if (tabIndex == this.indexOfComponent(this.secondIDATPanel)) {
            return this.secondIDATPanel.getGSEditorToolBar();
        }
        if (tabIndex == this.indexOfComponent(this.thirdIDATPanel)) {
            return this.thirdIDATPanel.getGSEditorToolBar();
        }
        return null;
    }

    class GSEditorFocusListener
    implements FocusListener {
        protected GSHTMLEditorTextPane gsHTMLEditorTextPane;
        protected int index;

        public GSEditorFocusListener(GSHTMLEditorTextPane gsHTMLEditorTextPane, int index) {
            this.gsHTMLEditorTextPane = gsHTMLEditorTextPane;
            this.index = index;
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.gsHTMLEditorTextPane.setCaretPosition(this.index);
            this.gsHTMLEditorTextPane.removeFocusListener(this);
        }

        @Override
        public void focusLost(FocusEvent e) {
        }
    }

    class GSTabbedPaneMouseAdapter
    extends MouseAdapter {
        private GSEditorFrame parent;

        public GSTabbedPaneMouseAdapter(GSEditorFrame parent) {
            this.parent = parent;
        }

        @Override
        public void mouseEntered(MouseEvent me) {
            if (this.parent instanceof WorkspaceWindow) {
                SearchDialogManager.setGSEditorToolBar(WorkspaceWindow.getInstance().getGSEditorToolBar());
            } else if (this.parent instanceof GSEditor) {
                SearchDialogManager.setGSEditorToolBar(((GSEditor)this.parent).getGSEditorToolBar());
            }
        }
    }

    class TabTitleEditListener
    extends MouseAdapter
    implements ChangeListener {
        private final JTextField editor = new JTextField();
        private final GSTabbedPane tabbedPane;
        private int editing_idx = -1;
        private int len = -1;
        private Dimension dim;
        private Component tabComponent = null;

        public TabTitleEditListener(final GSTabbedPane tabbedPane) {
            this.tabbedPane = tabbedPane;
            this.editor.setBorder(BorderFactory.createEmptyBorder());
            this.editor.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    TabTitleEditListener.this.renameTabTitle();
                }
            });
            this.editor.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        TabTitleEditListener.this.renameTabTitle();
                    } else if (e.getKeyCode() == 27) {
                        TabTitleEditListener.this.cancelEditing();
                    } else {
                        TabTitleEditListener.this.editor.setPreferredSize(TabTitleEditListener.this.editor.getText().length() > TabTitleEditListener.this.len ? null : TabTitleEditListener.this.dim);
                        tabbedPane.revalidate();
                    }
                }
            });
            tabbedPane.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0), "start-editing");
            tabbedPane.getActionMap().put("start-editing", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TabTitleEditListener.this.startEditing();
                }
            });
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.renameTabTitle();
        }

        @Override
        public void mouseClicked(MouseEvent me) {
            Rectangle rect = this.tabbedPane.getUI().getTabBounds(this.tabbedPane, this.tabbedPane.getSelectedIndex());
            if (rect != null && rect.contains(me.getPoint()) && me.getClickCount() == 2) {
                this.startEditing();
            } else {
                this.renameTabTitle();
            }
        }

        private void startEditing() {
            this.editing_idx = this.tabbedPane.getSelectedIndex();
            this.tabComponent = this.tabbedPane.getTabComponentAt(this.editing_idx);
            System.out.print(this.editing_idx);
            this.tabbedPane.setTabComponentAt(this.editing_idx, this.editor);
            this.editor.setVisible(true);
            this.editor.setText(this.tabbedPane.getTitleAt(this.editing_idx));
            this.editor.selectAll();
            this.editor.requestFocusInWindow();
            this.len = this.editor.getText().length();
            this.dim = this.editor.getPreferredSize();
            this.editor.setMinimumSize(this.dim);
        }

        private void cancelEditing() {
            if (this.editing_idx >= 0) {
                this.tabbedPane.setTabComponentAt(this.editing_idx, this.tabComponent);
                this.editor.setVisible(false);
                this.editing_idx = -1;
                this.len = -1;
                this.tabComponent = null;
                this.editor.setPreferredSize(null);
                this.tabbedPane.requestFocusInWindow();
            }
        }

        private void renameTabTitle() {
            Spread spread = this.tabbedPane.getSpread();
            String title = this.editor.getText().trim();
            if (this.editing_idx >= 0 && !title.equals("Image")) {
                int index = this.editing_idx;
                if (this.tabbedPane.getTitleAt(0) == "Image") {
                    --index;
                }
                if (index == 0 && !title.equals(spread.getSecondIDATName()) && !title.equals(spread.getThirdIDATName()) || index == 1 && !title.equals(spread.getFirstIDATName()) && !title.equals(spread.getThirdIDATName()) || index == 2 && !title.equals(spread.getFirstIDATName()) && !title.equals(spread.getSecondIDATName())) {
                    if (index == 0) {
                        spread.setFirstIDATName(title);
                    } else if (index == 1) {
                        spread.setSecondIDATName(title);
                    } else {
                        spread.setThirdIDATName(title);
                    }
                }
                IDATNameInGSTabbedPaneManager.updateTabtitles();
            }
            this.cancelEditing();
        }
    }
}

