/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.spread_selection;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JCheckBox;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import smart_gs.spread_selection.CheckBoxNode;

class CheckBoxNodeRenderer
implements TreeCellRenderer {
    private JCheckBox leafRenderer = new JCheckBox();
    private DefaultTreeCellRenderer nonLeafRenderer = new DefaultTreeCellRenderer();
    Color selectionBorderColor;
    Color selectionForeground;
    Color selectionBackground;
    Color textForeground;
    Color textBackground;

    protected JCheckBox getLeafRenderer() {
        return this.leafRenderer;
    }

    public CheckBoxNodeRenderer() {
        Boolean booleanValue;
        Font fontValue = UIManager.getFont("Tree.font");
        if (fontValue != null) {
            this.leafRenderer.setFont(fontValue);
        }
        this.leafRenderer.setFocusPainted((booleanValue = (Boolean)UIManager.get("tree.drawsFocusBorderAroundIcon")) != null && booleanValue != false);
        this.selectionBorderColor = UIManager.getColor("tree.selectionBorderColor");
        this.selectionForeground = UIManager.getColor("tree.selectionForeground");
        this.selectionBackground = UIManager.getColor("tree.selectionBackground");
        this.textForeground = UIManager.getColor("tree.textForeground");
        this.textBackground = UIManager.getColor("tree.textBackground");
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Component returnValue;
        if (leaf) {
            Object userObject;
            String stringValue = tree.convertValueToText(value, selected, expanded, leaf, row, false);
            this.leafRenderer.setText(stringValue);
            this.leafRenderer.setSelected(false);
            this.leafRenderer.setEnabled(tree.isEnabled());
            if (selected) {
                this.leafRenderer.setForeground(this.selectionForeground);
                this.leafRenderer.setBackground(this.selectionBackground);
            } else {
                this.leafRenderer.setForeground(this.textForeground);
                this.leafRenderer.setBackground(this.textBackground);
            }
            if (value != null && value instanceof DefaultMutableTreeNode && (userObject = ((DefaultMutableTreeNode)value).getUserObject()) instanceof CheckBoxNode) {
                CheckBoxNode node = (CheckBoxNode)userObject;
                this.leafRenderer.setText(node.getText());
                this.leafRenderer.setSelected(node.isSelected());
            }
            returnValue = this.leafRenderer;
        } else {
            returnValue = this.nonLeafRenderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        }
        return returnValue;
    }
}

