/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.spread_selection;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import smart_gs.logical.SpreadSelectionList;
import smart_gs.logical.SpreadSelectionListManager;
import smart_gs.spread_selection.TableHeaderSorter;
import smart_gs.spread_selection.TableSorter;
import smart_gs.swingui.WorkspaceWindow;

public class SpreadSelectionListsInTable {
    private CustomTableModel model;
    private JTable table;
    private Vector keys = new Vector();
    private Vector values = new Vector();
    private Vector switches = new Vector();
    private JButton SSLTreeFramesShowButton;
    private JTextField scopefield;
    boolean calledFromSearchPanel;

    public SpreadSelectionListsInTable(JButton bttn) {
        this.SSLTreeFramesShowButton = bttn;
        this.calledFromSearchPanel = false;
    }

    public SpreadSelectionListsInTable(JButton bttn, JTextField txtfld) {
        this.SSLTreeFramesShowButton = bttn;
        this.scopefield = txtfld;
        this.calledFromSearchPanel = true;
    }

    public void show() {
        JFrame frame = new JFrame("Selection Lists");
        frame.setResizable(true);
        frame.addWindowListener(new ShowFrameListener());
        this.model = new CustomTableModel();
        this.model.spreadSelectionListsUpdate();
        TableSorter sorter = new TableSorter(this.model);
        this.table = new JTable(sorter);
        TableHeaderSorter.install(sorter, this.table);
        TableColumn name_col = this.table.getColumnModel().getColumn(0);
        TableColumn spec_col = this.table.getColumnModel().getColumn(1);
        TableColumn checkbox_col = this.table.getColumnModel().getColumn(2);
        name_col.setPreferredWidth(100);
        spec_col.setPreferredWidth(200);
        checkbox_col.setPreferredWidth(10);
        Container content = frame.getContentPane();
        JScrollPane scrollPane = new JScrollPane(this.table);
        content.add((Component)scrollPane, "Center");
        JPanel button_panel = new JPanel();
        if (this.calledFromSearchPanel) {
            JButton load = new JButton("Load");
            load.addActionListener(new GUILoadSpreadSelectionListAction());
            button_panel.add(load);
        }
        JButton delete = new JButton("Delete");
        delete.addActionListener(new GUIDeleteSpreadSelectionListAction());
        button_panel.add(delete);
        frame.getContentPane().add((Component)button_panel, "South");
        frame.setSize(400, 400);
        frame.setVisible(true);
    }

    class CustomTableModel
    extends AbstractTableModel {
        private final String[] columnNames = new String[]{"Name", "Selection List", ""};

        CustomTableModel() {
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        @Override
        public int getRowCount() {
            return SpreadSelectionListsInTable.this.keys.size();
        }

        @Override
        public Object getValueAt(int row, int column) {
            Object returnValue = null;
            if (column == 0) {
                returnValue = SpreadSelectionListsInTable.this.keys.elementAt(row);
            } else if (column == 1) {
                returnValue = SpreadSelectionListsInTable.this.values.elementAt(row);
            } else if (column == 2) {
                returnValue = SpreadSelectionListsInTable.this.switches.elementAt(row);
            }
            return returnValue;
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            if (column == 2) {
                SpreadSelectionListsInTable.this.switches.set(row, value);
            }
        }

        public synchronized void spreadSelectionListsUpdate() {
            Enumeration<SpreadSelectionList> newSpreadSelectionLists = Collections.enumeration(SpreadSelectionListManager.getInstance().getSpreadSelectionLists());
            SpreadSelectionListsInTable.this.keys.removeAllElements();
            SpreadSelectionListsInTable.this.values.removeAllElements();
            SpreadSelectionListsInTable.this.switches.removeAllElements();
            while (newSpreadSelectionLists.hasMoreElements()) {
                SpreadSelectionList next = newSpreadSelectionLists.nextElement();
                SpreadSelectionListsInTable.this.keys.addElement(next.getName());
                SpreadSelectionListsInTable.this.values.addElement(next.getSpreadSelectionListSpec());
                SpreadSelectionListsInTable.this.switches.addElement(new Boolean(false));
            }
            this.fireTableDataChanged();
            WorkspaceWindow.setUpdated(true);
        }
    }

    private class GUIDeleteSpreadSelectionListAction
    implements ActionListener {
        private GUIDeleteSpreadSelectionListAction() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            int size = SpreadSelectionListsInTable.this.keys.size();
            SpreadSelectionListManager SSLM = SpreadSelectionListManager.getInstance();
            int i = 0;
            while (i < size) {
                if (((Boolean)SpreadSelectionListsInTable.this.switches.get(i)).booleanValue()) {
                    SSLM.deleteSpreadSelectionList((String)SpreadSelectionListsInTable.this.keys.get(i));
                }
                ++i;
            }
            SpreadSelectionListsInTable.this.model.spreadSelectionListsUpdate();
            SpreadSelectionListsInTable.this.model.fireTableStructureChanged();
            SpreadSelectionListsInTable.this.table.repaint();
        }
    }

    private class GUILoadSpreadSelectionListAction
    implements ActionListener {
        private GUILoadSpreadSelectionListAction() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            String scope_spec = "";
            int size = SpreadSelectionListsInTable.this.keys.size();
            SpreadSelectionListManager SSLM = SpreadSelectionListManager.getInstance();
            int i = 0;
            while (i < size - 1) {
                if (((Boolean)SpreadSelectionListsInTable.this.switches.get(i)).booleanValue()) {
                    scope_spec = String.valueOf(scope_spec) + SSLM.getSpreadSelectionListString((String)SpreadSelectionListsInTable.this.keys.get(i)) + ",";
                }
                ++i;
            }
            if (((Boolean)SpreadSelectionListsInTable.this.switches.get(size - 1)).booleanValue()) {
                scope_spec = String.valueOf(scope_spec) + SSLM.getSpreadSelectionListString((String)SpreadSelectionListsInTable.this.keys.get(size - 1));
            }
            SpreadSelectionListsInTable.this.scopefield.setText(scope_spec);
        }
    }

    private class ShowFrameListener
    extends WindowAdapter {
        private ShowFrameListener() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            SpreadSelectionListsInTable.this.SSLTreeFramesShowButton.setEnabled(true);
        }
    }
}

