/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.swingui.toolbar;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import smart_gs.smleditor.swingui.GSEditorTextPane;
import smart_gs.swingui.toolbar.GSMarkupAction;
import smart_gs.swingui.toolbar.GSRemoveTagAction;
import sml_editor.swingui.toolbar.EditorToolBar;
import sml_editor.swingui.toolbar.EditorToolBarPlan;

public class GSEditorToolBar
extends EditorToolBar
implements ActionListener {
    public GSEditorToolBar(GSEditorTextPane textPane) {
        this(textPane, new EditorToolBarPlan());
    }

    public GSEditorToolBar(GSEditorTextPane textPane, EditorToolBarPlan toolBarPlan) {
        super(textPane, toolBarPlan);
        this.markup.removeActionListener(this.markupAction);
        this.markupAction = new GSMarkupAction();
        this.markupAction.setEditorTextPane(textPane);
        this.markup.addActionListener(this.markupAction);
        this.removeTag.removeActionListener(this.removeTagAction);
        this.removeTagAction = new GSRemoveTagAction();
        this.browse.addActionListener(this);
        this.browse.setToolTipText("Browse");
        this.edit.addActionListener(this);
        this.edit.setToolTipText("Edit");
        this.source.addActionListener(this);
        this.source.setToolTipText("Source");
        if (toolBarPlan.isSource()) {
            this.add((Component)this.source, 0);
        }
        if (toolBarPlan.isEdit()) {
            this.add((Component)this.edit, 0);
        }
        if (toolBarPlan.isBrowse()) {
            this.add((Component)this.browse, 0);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.source)) {
            this.onSourcemode();
        } else if (e.getSource().equals(this.browse)) {
            this.onBrowseMode();
        } else if (e.getSource().equals(this.edit)) {
            this.onEditMode();
        }
    }

    public void tabChanged() {
        if (this.edit_mode == 1) {
            this.onSourcemode();
        } else if (this.edit_mode == 0) {
            this.onBrowseMode();
        } else if (this.edit_mode == 2) {
            this.onEditMode();
        }
    }

    public void onSourcemode() {
        this.edit_mode = 1;
        this.browse.setSelected(false);
        this.edit.setSelected(false);
        this.source.setSelected(true);
        this.textPane.setMenuMode(true);
        this.textPane.setSourceMode(true);
        this.textPane.setEdit(false);
        this.textPane.updateUI();
    }

    public void onBrowseMode() {
        this.edit_mode = 0;
        this.textPane.setMenuMode(true);
        this.textPane.setSourceMode(false);
        this.textPane.setEdit(false);
        this.textPane.updateUI();
        this.browse.setSelected(true);
        this.edit.setSelected(false);
        this.source.setSelected(false);
    }

    public void onEditMode() {
        this.edit_mode = 2;
        this.textPane.setMenuMode(false);
        this.textPane.setSourceMode(false);
        this.textPane.setEdit(true);
        this.textPane.updateUI();
        this.browse.setSelected(false);
        this.edit.setSelected(true);
        this.source.setSelected(false);
    }

    public int getMode() {
        if (this.browse.isSelected()) {
            return 0;
        }
        if (this.edit.isSelected()) {
            return 1;
        }
        if (this.source.isSelected()) {
            return 2;
        }
        return -1;
    }
}

