/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.swingui.toolbar;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import javax.swing.plaf.metal.MetalToolTipUI;
import smart_gs.logical.Spread;
import smart_gs.swingui.AbstractGSWindow;
import smart_gs.swingui.WorkspaceWindow;

public class HistoryToolBar
extends JToolBar
implements ActionListener {
    protected ArrayList<Spread> historyList = new ArrayList();
    protected static ArrayList<Integer> historyCanvasScale = new ArrayList();
    protected JButton prev = new JButton((Icon)new ImageIcon("./icons/prev_history.png")){

        @Override
        public JToolTip createToolTip() {
            MultiLineToolTip tip = new MultiLineToolTip();
            tip.setComponent(this);
            return tip;
        }
    };
    private String prevString = "Move to previous page in history.";
    protected JButton next;
    private String nextString = "Move to next page in history.";
    protected int historycounter = 0;
    private final int DEFAULT_WIDTH = 1200;
    private final int ZOOM_VALUE = 200;
    private AbstractGSWindow parent;

    public HistoryToolBar(AbstractGSWindow parent) {
        this.prev.setEnabled(false);
        this.prev.addActionListener(this);
        this.prev.setActionCommand("prev");
        this.prev.setToolTipText(this.prevString);
        this.prev.setMnemonic(37);
        this.add(this.prev);
        this.next = new JButton((Icon)new ImageIcon("./icons/next_history.png")){

            @Override
            public JToolTip createToolTip() {
                MultiLineToolTip tip = new MultiLineToolTip();
                tip.setComponent(this);
                return tip;
            }
        };
        this.next.setEnabled(false);
        this.next.addActionListener(this);
        this.next.setActionCommand("next");
        this.next.setToolTipText(this.nextString);
        this.next.setMnemonic(39);
        this.add(this.next);
        this.parent = parent;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("prev")) {
            Spread spreadTemp;
            int i;
            StringBuffer tipsBuf;
            --this.historycounter;
            Spread spread = this.historyList.get(this.historycounter);
            int scale = historyCanvasScale.get(this.historycounter);
            WorkspaceWindow.getInstance().setSpread(spread, false);
            WorkspaceWindow.getInstance().setImageSearch(spread.toString());
            WorkspaceWindow.getInstance().getSpreadCanvas().imageLabel.setScale(scale);
            WorkspaceWindow.getInstance().getSpreadCanvas().imageLabel.showImage();
            if (this.historycounter < 1) {
                this.prev.setEnabled(false);
                this.prev.setToolTipText(null);
            } else {
                tipsBuf = new StringBuffer();
                tipsBuf.append(String.valueOf(this.prevString) + "\n");
                i = this.historycounter - 1;
                while (i >= 0) {
                    spreadTemp = this.historyList.get(i);
                    tipsBuf.append(String.valueOf(spreadTemp.getViewName()) + "\n");
                    --i;
                }
                this.prev.setToolTipText(tipsBuf.toString());
            }
            tipsBuf = new StringBuffer();
            tipsBuf.append(String.valueOf(this.nextString) + "\n");
            i = this.historycounter + 1;
            while (i < this.historyList.size()) {
                spreadTemp = this.historyList.get(i);
                tipsBuf.append(String.valueOf(spreadTemp.getViewName()) + "\n");
                ++i;
            }
            this.next.setEnabled(true);
            this.next.setToolTipText(tipsBuf.toString());
        } else if (e.getActionCommand().equals("next")) {
            Spread spreadTemp;
            int i;
            StringBuffer tipsBuf;
            ++this.historycounter;
            Spread spread = this.historyList.get(this.historycounter);
            int scale = historyCanvasScale.get(this.historycounter);
            WorkspaceWindow.getInstance().setSpread(spread, false);
            WorkspaceWindow.getInstance().setImageSearch(spread.toString());
            WorkspaceWindow.getInstance().getSpreadCanvas().imageLabel.setScale(scale);
            WorkspaceWindow.getInstance().getSpreadCanvas().imageLabel.showImage();
            if (this.historyList.size() - 1 <= this.historycounter) {
                this.next.setEnabled(false);
                this.next.setToolTipText(null);
            } else {
                tipsBuf = new StringBuffer();
                tipsBuf.append(String.valueOf(this.nextString) + "\n");
                i = this.historycounter + 1;
                while (i < this.historyList.size()) {
                    spreadTemp = this.historyList.get(i);
                    tipsBuf.append(String.valueOf(spreadTemp.getViewName()) + "\n");
                    ++i;
                }
                this.next.setToolTipText(tipsBuf.toString());
            }
            if (this.historycounter >= 1) {
                tipsBuf = new StringBuffer();
                tipsBuf.append(String.valueOf(this.prevString) + "\n");
                i = this.historycounter - 1;
                while (i >= 0) {
                    spreadTemp = this.historyList.get(i);
                    tipsBuf.append(String.valueOf(spreadTemp.getViewName()) + "\n");
                    --i;
                }
                this.prev.setEnabled(true);
                this.prev.setToolTipText(tipsBuf.toString());
            }
        }
    }

    public void addHistory(Spread spread, int scale) {
        if (this.historycounter != this.historyList.size() - 1) {
            int i = this.historycounter;
            while (i < this.historyList.size()) {
                this.historyList.remove(this.historycounter + 1);
                historyCanvasScale.remove(this.historycounter + 1);
                ++i;
            }
        }
        this.historyList.add(spread);
        historyCanvasScale.add(scale);
        this.historycounter = this.historyList.size() - 1;
        if (this.historycounter >= 1) {
            StringBuffer tipsBuf = new StringBuffer();
            int i = this.historycounter - 1;
            while (i >= 0) {
                Spread spreadTemp = this.historyList.get(i);
                tipsBuf.append(String.valueOf(spreadTemp.getViewName()) + "\n");
                --i;
            }
            this.prev.setEnabled(true);
            this.prev.setToolTipText(tipsBuf.toString());
        }
        this.next.setEnabled(false);
        this.next.setToolTipText(null);
    }

    public void zoomInHistoryCanvasScale() {
        int scale = historyCanvasScale.remove(this.historycounter);
        historyCanvasScale.add(this.historycounter, ++scale);
    }

    public void zoomOutHistoryCanvasScale() {
        int scale = historyCanvasScale.remove(this.historycounter);
        historyCanvasScale.add(this.historycounter, --scale);
    }

    public void fullSizeHistoryCanvasScale() {
        this.setHistoryCanvasScale(0);
    }

    public void fitWidthHistoryCanvasScale() {
        int width = this.parent.getSpreadCanvas().getWidth();
        int scale = (width - 1200) / 200 - 1;
        this.setHistoryCanvasScale(scale);
    }

    public void fitHeightHistoryCanvasScale() {
        int height = this.parent.getSpreadCanvas().getHeight();
        double ratio = (double)this.parent.getSpreadCanvas().imageLabel.getImageWidth() / (double)this.parent.getSpreadCanvas().imageLabel.getImageHeight();
        int scale = (int)((ratio * (double)height - 1200.0) / 200.0 - 1.0);
        this.setHistoryCanvasScale(scale);
    }

    public void setHistoryCanvasScale(int scale) {
        historyCanvasScale.remove(this.historycounter);
        historyCanvasScale.add(this.historycounter, scale);
    }

    class MultiLineToolTip
    extends JToolTip {
        public MultiLineToolTip() {
            this.setUI(new MultiLineToolTipUI());
        }
    }

    class MultiLineToolTipUI
    extends MetalToolTipUI {
        private String[] strs;
        private int maxWidth = 0;

        MultiLineToolTipUI() {
        }

        @Override
        public void paint(Graphics g, JComponent c) {
            FontMetrics metrics = Toolkit.getDefaultToolkit().getFontMetrics(g.getFont());
            Dimension size = c.getSize();
            g.setColor(c.getBackground());
            g.fillRect(0, 0, size.width, size.height);
            g.setColor(c.getForeground());
            if (this.strs != null) {
                int i = 0;
                while (i < this.strs.length) {
                    g.drawString(this.strs[i], 3, metrics.getHeight() * (i + 1));
                    ++i;
                }
            }
        }

        @Override
        public Dimension getPreferredSize(JComponent c) {
            FontMetrics metrics = Toolkit.getDefaultToolkit().getFontMetrics(c.getFont());
            String tipText = ((JToolTip)c).getTipText();
            if (tipText == null) {
                tipText = "";
            }
            BufferedReader br = new BufferedReader(new StringReader(tipText));
            int maxWidth = 0;
            Vector<String> v = new Vector<String>();
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    int width = SwingUtilities.computeStringWidth(metrics, line);
                    maxWidth = maxWidth < width ? width : maxWidth;
                    v.addElement(line);
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            int lines = v.size();
            if (lines < 1) {
                this.strs = null;
                lines = 1;
            } else {
                this.strs = new String[lines];
                int i = 0;
                Enumeration e = v.elements();
                while (e.hasMoreElements()) {
                    this.strs[i] = (String)e.nextElement();
                    ++i;
                }
            }
            int height = metrics.getHeight() * lines;
            this.maxWidth = maxWidth;
            return new Dimension(maxWidth + 6, height + 4);
        }
    }
}

