/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.text_search;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import smart_gs.logical.SmartDocument;
import smart_gs.logical.Spread;
import smart_gs.logical.UsersNoteTree;
import smart_gs.text_search.logical.SearchResult;
import smart_gs.text_search.swingui.TextToShow;
import smart_gs.util.StringUtils;

public class TextSearchEngine {
    private static TextSearchEngine singleton = new TextSearchEngine();
    private String queryText;
    private List<Spread> spreadsToSearch;
    private int documentType;
    private List<SearchResult> results;
    private SmartDocument document;
    private boolean isCaseSensitive;
    private boolean isRegularExpressions;

    public static TextSearchEngine getInstance() {
        return singleton;
    }

    public void setQueryText(String queryText) {
        this.queryText = queryText;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.isCaseSensitive = caseSensitive;
    }

    public void setRegularExpressions(boolean regularExpressions) {
        this.isRegularExpressions = regularExpressions;
    }

    public void setSearchScope(List<Spread> spreadsToSearch) {
        this.spreadsToSearch = spreadsToSearch;
    }

    public void setDocumentType(int documentType) {
        this.documentType = documentType;
    }

    public void execute() {
        this.results = new ArrayList<SearchResult>();
        switch (this.documentType) {
            case 5: {
                ArrayList arrList1 = (ArrayList)UsersNoteTree.getInstance().getUsersNotes();
                Iterator it1 = arrList1.iterator();
                while (it1.hasNext()) {
                    this.addResults(this.queryText, (SmartDocument)it1.next(), this.isCaseSensitive, this.isRegularExpressions);
                }
                break;
            }
            case 1: {
                int i = 0;
                while (i < this.spreadsToSearch.size()) {
                    this.document = this.spreadsToSearch.get(i).getFirstIDAT();
                    this.addResults(this.queryText, this.document, this.isCaseSensitive, this.isRegularExpressions);
                    ++i;
                }
                break;
            }
            case 3: {
                int i = 0;
                while (i < this.spreadsToSearch.size()) {
                    this.document = this.spreadsToSearch.get(i).getFirstIDAT();
                    this.addResults(this.queryText, this.document, this.isCaseSensitive, this.isRegularExpressions);
                    ++i;
                }
                break;
            }
            case 2: {
                int i = 0;
                while (i < this.spreadsToSearch.size()) {
                    this.document = this.spreadsToSearch.get(i).getSecondIDAT();
                    this.addResults(this.queryText, this.document, this.isCaseSensitive, this.isRegularExpressions);
                    ++i;
                }
                break;
            }
            case 4: {
                int i = 0;
                while (i < this.spreadsToSearch.size()) {
                    this.document = this.spreadsToSearch.get(i).getFirstIDAT();
                    this.addResults(this.queryText, this.document, this.isCaseSensitive, this.isRegularExpressions);
                    this.document = this.spreadsToSearch.get(i).getThirdIDAT();
                    this.addResults(this.queryText, this.document, this.isCaseSensitive, this.isRegularExpressions);
                    this.document = this.spreadsToSearch.get(i).getSecondIDAT();
                    this.addResults(this.queryText, this.document, this.isCaseSensitive, this.isRegularExpressions);
                    ++i;
                }
                ArrayList arrList2 = (ArrayList)UsersNoteTree.getInstance().getUsersNotes();
                Iterator it2 = arrList2.iterator();
                while (it2.hasNext()) {
                    this.addResults(this.queryText, (SmartDocument)it2.next(), this.isCaseSensitive, this.isRegularExpressions);
                }
                break;
            }
        }
    }

    private void addResults(String queryText, SmartDocument document, boolean isCaseSensitive, boolean isRegularExpressions) {
        String documentURI = document.getURI();
        String source = document.getSource();
        String planeText = this.source2Text(source);
        String ccQuery = this.convertCase(queryText, isCaseSensitive);
        String ccText = this.convertCase(planeText, isCaseSensitive);
        int lengthOfQuery = queryText.length();
        int i = 0;
        if (ccText == null) {
            return;
        }
        if (isRegularExpressions) {
            try {
                Pattern p = Pattern.compile(ccQuery);
                Matcher m = p.matcher(ccText);
                while (m.find()) {
                    int indexOfResult = m.start();
                    String resultStr = m.group();
                    SearchResult result = new SearchResult();
                    result.setResult(resultStr, documentURI, indexOfResult);
                    TextToShow textToShow = this.textToShow(indexOfResult, resultStr.length(), planeText);
                    result.setTextToShow(textToShow);
                    this.results.add(result);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (ccText.indexOf(ccQuery) != -1) {
            while (true) {
                int indexOfResult;
                if ((indexOfResult = ccText.indexOf(ccQuery, i)) == -1) {
                    i = 0;
                    break;
                }
                SearchResult result = new SearchResult();
                result.setResult(queryText, documentURI, indexOfResult);
                TextToShow textToShow = this.textToShow(indexOfResult, lengthOfQuery, planeText);
                result.setTextToShow(textToShow);
                this.results.add(result);
                i = indexOfResult + ccQuery.length();
            }
        }
    }

    private String source2Text(String source) {
        String planeText = source;
        planeText = StringUtils.replaceString(planeText, "<br>", "\n");
        Pattern pattern = Pattern.compile("<.+?>", 32);
        Matcher matcher = pattern.matcher(planeText);
        planeText = matcher.replaceAll("");
        planeText = planeText.replaceAll("&quot;", "\"");
        planeText = planeText.replaceAll("&gt;", "<");
        planeText = planeText.replaceAll("&lt;", ">");
        planeText = planeText.replaceAll("&amp;", "&");
        return planeText;
    }

    private String convertCase(String source, boolean isCaseSensitive) {
        if (source == null) {
            return null;
        }
        if (isCaseSensitive) {
            return source;
        }
        return source.toLowerCase();
    }

    private TextToShow textToShow(int index, int lengthOfQuery, String text) {
        String textToShow = text.substring(index, index + lengthOfQuery);
        int num = 10;
        int length = text.length();
        String pre = index + 1 <= 10 ? (index == 0 ? "" : text.substring(0, index)) : "..." + text.substring(index - 10, index);
        String query = text.substring(index, index + lengthOfQuery);
        String fol = length - index - lengthOfQuery <= 10 ? (length - index - lengthOfQuery == 0 ? "" : text.substring(index + lengthOfQuery)) : String.valueOf(text.substring(index + lengthOfQuery, index + lengthOfQuery + 10)) + "...";
        textToShow = String.valueOf(pre) + query + fol;
        return new TextToShow(textToShow, pre.length(), lengthOfQuery);
    }

    public List<SearchResult> getResults() {
        return this.results;
    }
}

