/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import smart_gs.util.GSStandardPath;

public class GSPathStringGrammarChecker {
    static GSPathStringIdentifierGrammarChecker idChecker = new GSPathStringIdentifierGrammarChecker();
    static WindowsHeaderChecker winHeaderChecker = new WindowsHeaderChecker();

    public static boolean isGsPath(String string0) {
        String string = GSStandardPath.normalizeSeparators(string0);
        return GSPathStringGrammarChecker.isGsWinAbsolutePath(string) || GSPathStringGrammarChecker.isGsUnixAbsolutePath(string) || GSPathStringGrammarChecker.isGsRelativePath(string);
    }

    public static boolean confusingSeparators(String string) {
        return string.indexOf("\\") != -1 & string.indexOf("/") != -1;
    }

    public static boolean endsWithUnixSeparator(String string) {
        return string.endsWith("/");
    }

    public static boolean endsWithWinSeparator(String string) {
        return string.endsWith("\\");
    }

    public static boolean endsWithSeparator(String string) {
        return string.endsWith("\\") || string.endsWith("/");
    }

    public static boolean hasWinDriveHeader(String string) {
        return winHeaderChecker.checks(string);
    }

    public static boolean isGsWinAbsolutePath(String string) {
        if (!GSPathStringGrammarChecker.hasWinDriveHeader(string = GSStandardPath.normalizeSeparators(string))) {
            return false;
        }
        String rest = string.substring(2, string.length());
        if (rest.equals("")) {
            return true;
        }
        return GSPathStringGrammarChecker.isUnixTypeAbsolutePath(rest);
    }

    public static boolean isGsRelativePath(String string) {
        string = GSStandardPath.normalizeSeparators(string);
        return GSPathStringGrammarChecker.isUnixTypeRelativePath(string);
    }

    public static boolean isGsUnixAbsolutePath(String string) {
        string = GSStandardPath.normalizeSeparators(string);
        return GSPathStringGrammarChecker.isUnixTypeAbsolutePath(string);
    }

    private static boolean isUnixTypeAbsolutePath(String string) {
        int length = string.length();
        if (length == 0) {
            return false;
        }
        if (string.charAt(0) != '/') {
            return false;
        }
        if (string.length() == 1) {
            return true;
        }
        return GSPathStringGrammarChecker.isUnixTypeRelativePath(string.substring(1, length));
    }

    private static boolean isUnixTypeRelativePath(String string) {
        int length = string.length();
        if (length == 0) {
            return false;
        }
        if (string.charAt(0) == '/') {
            return false;
        }
        String[] names = string.split("\\/");
        int i = 0;
        while (i < names.length) {
            if (!GSPathStringGrammarChecker.isFileDirIdentifier(names[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isFileDirIdentifier(String string) {
        if ((string = GSStandardPath.normalizeSeparators(string)).equals("")) {
            return false;
        }
        return idChecker.checks(string);
    }

    private static class GSPathStringIdentifierGrammarChecker {
        String zenkakuKanjiKanaOrAscii = "([\ufffd\ufffd-\ufffd]|[\ufffd\ufffd-\ufffd\ufffd]|[\ufffd@-\ufffd\ufffd]|[\\x20-\\x7e])+";
        String excludedForWin = "[\\x22\\x2a\\x2f\\x3a\\x3c\\x3e\\x3f\\x5c\\x7c]";
        private Pattern patternZenkakuOrAscii = Pattern.compile(this.zenkakuKanjiKanaOrAscii);
        private Pattern patternExcludedForWin = Pattern.compile(this.excludedForWin);

        public boolean checks(String string) {
            if (string.equals(".") || string.equals("..")) {
                return true;
            }
            if (string.charAt(0) == '@' || string.charAt(0) == '#' || string.charAt(0) == '.') {
                return false;
            }
            if (!(string.length() != 3 || string.charAt(0) != 'd' && string.charAt(0) != 'D' || string.charAt(0) != 's' && string.charAt(0) != 'S' || string.charAt(0) != 'c' && string.charAt(0) != 'C')) {
                return false;
            }
            Matcher matcherZenkakuOrAscii = this.patternZenkakuOrAscii.matcher(string);
            Matcher matcherExcludedForWin = this.patternExcludedForWin.matcher(string);
            return matcherZenkakuOrAscii.matches() && !matcherExcludedForWin.find();
        }
    }

    private static class WindowsHeaderChecker {
        String windowsHeader = "([A-Z]|[a-z]):.*";
        private Pattern patternWindowsHeader = Pattern.compile(this.windowsHeader);

        public boolean checks(String string) {
            Matcher matcherWindowsHeader = this.patternWindowsHeader.matcher(string);
            return matcherWindowsHeader.matches();
        }
    }
}

