/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.util;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import smart_gs.logical.Region;
import smart_gs.logical.Spread;

public class ImageCropper {
    private Image image;
    private Rectangle2D rectangle;
    private int x;
    private int y;
    private int w;
    private int h;

    public ImageCropper(Region region) {
        this.image = region.getSpread().getImage();
        this.rectangle = region.getView().getRectangle2D();
        this.x = (int)this.rectangle.getX();
        this.y = (int)this.rectangle.getY();
        this.w = (int)this.rectangle.getWidth();
        this.h = (int)this.rectangle.getHeight();
    }

    public ImageCropper(Spread spread, Rectangle2D rectangle) {
        this.image = spread.getImage();
        this.rectangle = rectangle;
        this.x = (int)rectangle.getX();
        this.y = (int)rectangle.getY();
        this.w = (int)rectangle.getWidth();
        this.h = (int)rectangle.getHeight();
    }

    public ImageCropper(Image image, Rectangle2D rectangle) {
        this.image = image;
        this.rectangle = rectangle;
        this.x = (int)rectangle.getX();
        this.y = (int)rectangle.getY();
        this.w = (int)rectangle.getWidth();
        this.h = (int)rectangle.getHeight();
    }

    public ImageCropper(Image image, Region region) {
        this.image = image;
        this.rectangle = region.getView().getRectangle2D();
        this.x = (int)this.rectangle.getX();
        this.y = (int)this.rectangle.getY();
        this.w = (int)this.rectangle.getWidth();
        this.h = (int)this.rectangle.getHeight();
    }

    public Image crop() {
        BufferedImage bufImage = new BufferedImage(this.w, this.h, 1);
        Graphics offg = bufImage.getGraphics();
        offg.drawImage(this.image, 0, 0, this.w, this.h, this.x, this.y, this.x + this.w, this.y + this.h, null);
        return bufImage;
    }

    public Image crop(int width, int height) {
        Image img = this.crop();
        BufferedImage bufImage = new BufferedImage(width, height, 1);
        Graphics offg = bufImage.getGraphics();
        offg.drawImage(img, 0, 0, width, height, 0, 0, this.w, this.h, null);
        return bufImage;
    }

    public Image cropForLocalView() {
        int target_size = 140;
        BufferedImage bufImage = new BufferedImage(target_size, target_size, 1);
        Graphics offg = bufImage.getGraphics();
        int margin = 20;
        int center_point_x = this.x + this.w / 2;
        int center_point_y = this.y + this.h / 2;
        int sx1 = 0;
        int sy1 = 0;
        int source_size = 0;
        source_size = this.w < target_size - margin && this.h < target_size - margin ? target_size : Math.max(this.w, this.h) + 2 * margin;
        sx1 = center_point_x - source_size / 2;
        sy1 = center_point_y - source_size / 2;
        offg.drawImage(this.image, 0, 0, target_size, target_size, sx1, sy1, sx1 + source_size, sy1 + source_size, null);
        return bufImage;
    }
}

