/*
 * Decompiled with CFR 0.152.
 */
package sml_editor.swingui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.DocumentListener;
import sml_editor.swingui.EditorFrame;
import sml_editor.swingui.EditorMouseListener;
import sml_editor.swingui.EditorTextPane;

public abstract class AbstractEditorPanel
extends JPanel
implements ComponentListener {
    protected EditorTextPane textPane;
    protected DocumentListener docListener;
    protected EditorMouseListener mouseListener;
    private JScrollPane scrollPane;
    protected EditorFrame parent;

    public AbstractEditorPanel(EditorFrame parent, EditorTextPane textPane) {
        this.textPane = textPane;
        this.parent = parent;
        this.setLayout(new BorderLayout());
        this.addComponentListener(this);
        this.docListener = this.getDocumentListener();
        this.mouseListener = this.getMouseListener();
        this.scrollPane = new JScrollPane();
        this.scrollPane.setViewportView(this.textPane);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(20);
        this.add((Component)this.scrollPane, "Center");
        this.textPane.getGSHTMLEditorTextPane().setDocumentListener(this.docListener);
        this.textPane.getGSHTMLEditorTextPane().setMouseListener(this.mouseListener);
    }

    public EditorTextPane getTextPane() {
        return this.textPane;
    }

    @Override
    public void componentHidden(ComponentEvent e) {
        this.textPane.removeMouseListener(this.mouseListener);
        this.textPane.getGSHTMLEditorTextPane().getStyledDocument().removeDocumentListener(this.docListener);
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
        this.scrollPane.setViewportView(this.textPane);
        this.docListener = this.getDocumentListener();
        this.mouseListener = this.getMouseListener();
        this.textPane.getGSHTMLEditorTextPane().setMouseListener(this.mouseListener);
        this.textPane.getGSHTMLEditorTextPane().setDocumentListener(this.docListener);
        this.validate();
        this.repaint();
    }

    public abstract JToolBar getToolbar();

    public abstract DocumentListener getDocumentListener();

    public abstract EditorMouseListener getMouseListener();
}

