/* $Id: RedoAction.java 125 2011-03-09 09:49:51Z ohura $ */
package com.hexidec.ekit.action;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;

import javax.swing.AbstractAction;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

import com.hexidec.ekit.GSHTMLEditor;
import com.hexidec.ekit.UndoSet;

/** Class for implementing Redo as an autonomous action
 */
public class RedoAction extends AbstractAction{
	protected GSHTMLEditor gsHTMLEditor;
	protected boolean keyevent = true;

	public RedoAction(GSHTMLEditor gsHTMLEditor){
		super("Redo*");
		this.gsHTMLEditor = gsHTMLEditor;
		setEnabled(false);
	}
	public void setKeyEvent(boolean keyevent){
		this.keyevent = keyevent;
	}
	public void redo(){
		if(keyevent){
			actionPerformed(null);
		}
	}
	public void actionPerformed(ActionEvent e){
		try{
			this.gsHTMLEditor.stopDocumentListener();
			UndoSet undoSet = this.gsHTMLEditor.getUndoManager().redo();
			if(undoSet != null){
				//int point = gsHTMLEditor.getCaretPosition();
				gsHTMLEditor.setSource(undoSet.getSource());
				gsHTMLEditor.setCaretPosition(undoSet.getPosition()+1);
			}
			this.gsHTMLEditor.startDocumentListener();
		}catch(CannotRedoException ex){
			// ex.printStackTrace();
		}
	}
    public boolean isEnabled() {
        return true;
    }

}
