/* $Id: TestRectConfirm.java 125 2011-03-09 09:49:51Z ohura $ */
/*
 * 쐬F 2006/09/12
 */
package jp.ac.hokudai.meme.core_smart_gs.test;

import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.io.*;

import jp.ac.hokudai.meme.core_smart_gs.InvalidDataFormatException;
import jp.ac.hokudai.meme.core_smart_gs.searcher.*;

public class TestRectConfirm {
    
    
    
    private IDocumentSearcher searchEngine_;
    private QueryRect query_;
    
    public TestRectConfirm(){
        searchEngine_ = DocumentSearcher.getInstance(IDocumentSearcher.TYPE_NORMAL);
    }
    
    public void loadDscFile(File dscFile) throws IOException{
        try {
            searchEngine_.addDscFile(new File[]{dscFile});
        } catch (InvalidDataFormatException e) {
            // TODO ꂽ catch ubN
            e.printStackTrace();
        }
    }
    
    public void setQueryRect(int queryPageIndex, Rectangle2D rect){
        
        PagedRect pagedRect = new PagedRect(queryPageIndex, new Rectangle((int)rect.getX(), (int)(rect.getY() + (rect.getHeight()/2)), (int)rect.getWidth(), 1));
        query_ = new QueryRect();
        query_.addQueryPRect(pagedRect);
        PagedRect[] queryRects = searchEngine_.rectConfirm(query_).getAllRects();
    }
    
    public ResultRects search(){
        
        ResultRects results = searchEngine_.search(query_);
        for(int i=1;i<=results.getSize();i++){
            PagedRect[] prect = results.getPRects(i);
            Rectangle firstRect = prect[0].getRect();
            Rectangle lastRect = prect[prect.length-1].getRect();
            int width = lastRect.x-firstRect.x+lastRect.width;
            Rectangle resRect = new Rectangle(firstRect.x,firstRect.y,width,firstRect.height);
            int pageIndex = prect[0].getPageIndex();
//            this.rankedList.add(new SearchResult(pagesToSearch.get(pageIndex),resRect,i));
        }
        return results;

    }
    
    /**
     * <p></p>
     * @param args
     * @throws IOException 
     */
    public static void main(String[] args) throws IOException {
        String filePath = "D:/sandbox/core_smart_gs/debug/002-003.dsc";
        TestRectConfirm test = new TestRectConfirm();
        File dscFile = new File(filePath);
        test.loadDscFile(dscFile);
        
        int page = 0;
        double x = 288;
        double y = 418;
        double w = 83;
        double h = 61;
        Rectangle2D rect = new Rectangle2D.Double(x, y , w, h);
        
        test.setQueryRect(page, rect);
        ResultRects rects = test.search();
        System.out.println("done.");
    }

}
