package smart_gs.drawing_tool.action;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;

import javax.swing.JOptionPane;
import javax.swing.JFrame;

import smart_gs.drawing_tool.ImageLabel;
import smart_gs.drawing_tool.SpreadCanvas;
import smart_gs.drawing_tool.state.DefaultState;
import smart_gs.drawing_tool.state.State;
import smart_gs.drawing_tool.state.UniSelectedState;
import smart_gs.image_search.GSSearchEngine;
import smart_gs.logical.LineSegment;
import smart_gs.logical.Spread;
import smart_gs.swingui.AbstractGSWindow;
import smart_gs.swingui.EditLineFrame;

public class ChangeSizeAction implements ActionListener{
	
	private AbstractGSWindow gsWindow;
	private double m;
	private Spread spread;
	
	

	public ChangeSizeAction(AbstractGSWindow gsWindow){
		this.gsWindow = gsWindow;
		
	}
	
	
	public void execute(){
		LineSegment line = spread.getLines().get(0);
		if(line == null){
			JOptionPane.showMessageDialog(new JFrame(), "null","error",  JOptionPane.INFORMATION_MESSAGE);
			return;
		}
		
		spread.changeLinesSize(m);
			
	}
	
	public void actionPerformed(ActionEvent e){
		this.spread = this.gsWindow.getSpread();
		if(ImageLabel.isLineShown()==false){
			JOptionPane.showMessageDialog(new JFrame(), "Please show Lines","error",  JOptionPane.INFORMATION_MESSAGE);
			return;
		}
		
		/*
		String sizeStr = JOptionPane
				.showInputDialog("Input Max Found Size");
		if (sizeStr == null) {
			return;
		}
		try {
			double size = (double)Integer.parseInt(sizeStr);
			this.m = size;
			this.execute();
		} catch (NumberFormatException nfe) {
			nfe.printStackTrace();
		}
		*/
		EditLineFrame frame = new EditLineFrame(this.gsWindow);
		frame.setVisible(true);
		return;
	}
		
	
}
