/* $Id: Preference.java 434 2011-10-18 14:28:15Z shayashi $ */
package smart_gs.logical;

import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.TimeZone;

import javax.swing.JOptionPane;

import org.apache.commons.io.FileUtils;

import smart_gs.debugprint.Debugprint;
import smart_gs.drawing_tool.state.UniSelectedState;
import smart_gs.drawing_tool.view.BookmarkView;
import smart_gs.image_search.GSSearchEngine;
import smart_gs.image_search.logical.TextType;
import smart_gs.util.GSUserNameGrammarChecker;


public class Preference {
	
	private static Preference singleton = new Preference();
	
	private String userName;

	private String gsFolderPathString;

	private String imageFolderPathString;

	private String dscFolderPathString;
	
	private String smart_exportFolderPathString;
	//
	private String defaultGsFilePathString;

	//2007/11/20 kazuhiro kobayashi
	private String nameCorrespondenceFilePathString;
	
	//2007/12/8 kazuhiro kobayshi
	private String RWBackgroundFilePathString;
	
	private boolean shouldLoadAll = false;
	// 20090123 NorthGrid
	// 0 = [Jt@C
	// 1 = WebDav
	private int filemode = 0;
	
	// 20090123 NorthGrid
	private String webdavServerPathString;
	private String webdavUserName;
	private String webdavPassword;
	
	// 20090222 NorthGrid
	private String browser;
	// 20090527 NorthGrid
	private String webdavunlock;
	// 20091014 NorthGrid
	private String editor;

	// 20090907 NorthGrid
	private String searchImageDictionaryLogic;
	
	// 20100419 NorthGrid
	private String proxyAddress;
	private String proxyPort;
	
	// 20090422 NorthGrid
	private static String preferenceFile = "preference.xml";
	private static String preferenceDefaultFile = "preference-default.xml";
	
	// 2011.02.20 shayashi
	private String firstIDATName;
	private String secondIDATName;
	private String thirdIDATName;
	
	// 2011.08.08 kukita
	private String markupMovability = "false";
	private String memoPadColor = "green";
	private String markerColor = "yellow";
	private String markerBreadth = "15";
	private String bookmarkSize = "1.0";
	private String resourceBasketSaveOption = "false";
	public static Preference getInstance(){
		return singleton;
	}
	
	public boolean shouldLoadAll(){
		return this.shouldLoadAll;
	}
	public void setShouldLoadAll(boolean shouldLoadAll) {
		this.shouldLoadAll = shouldLoadAll;
	}
	
	public String getUserName(){
		return userName;
	}
	public void setUserName(String userName0){
		if (GSUserNameGrammarChecker.checks(userName0)) {
			userName = userName0;
		} else {
			JOptionPane.showMessageDialog(null,
					"Error: a username must be a non-empty string of digits, alphabets, and -._@\nof at least 3 chars starting with an alphabet" , "message",
					JOptionPane.INFORMATION_MESSAGE);
		}
	}
	
	// 2011.02.20 shayashi
	public String getFirstIDATName() {
		return firstIDATName;
	}	
	public void setFirstIDATName(String name) {
		firstIDATName = name;
	}
	public String getSecondIDATName() {
		return secondIDATName;
	}	
	public void setSecondIDATName(String name) {
		secondIDATName = name;
	}
	public String getThirdIDATName() {
		return thirdIDATName;
	}	
	public void setThirdIDATName(String name) {
		thirdIDATName = name;
	}
	

	public int load(){
		try {
			Properties properties = new Properties();

			File file = new File(preferenceFile);
			if(!file.exists()) {
				File defaultFile = new File(preferenceDefaultFile);
				FileUtils.copyFile(defaultFile, file);
			}
			FileInputStream inStream = new FileInputStream(file);
			properties.loadFromXML(inStream);
			
			userName = properties.getProperty("userName");
			if (userName.equals("")) {
				userName = 
					JOptionPane.showInputDialog("Enter user name: a string of digits, alphabets, and -._@\nof at least 3 chars starting with an alphabet");
			}
			if (userName == null) userName = "";
			Object[] options = {"Input username", "Abort SMART-GS"};
			boolean nameCheck = false;
			boolean abortByUser = false;
			String oldUserName;
			do {
				if (GSUserNameGrammarChecker.checks(userName)) {
					Preference.getInstance().setUserName(userName);
					nameCheck = true;
				} else {
					nameCheck = false;
					oldUserName = userName;
					int answer = JOptionPane.showOptionDialog(null,
							"\"" + userName + "\"" + " invalid username\nUsername must be a string of digits, alphabets, and -._@\nof at least 3 chars starting with an alphabet",
							"user name request",
							JOptionPane.YES_NO_OPTION,
							JOptionPane.QUESTION_MESSAGE,
							null,   
							options,  
							options[0]); 
					if (answer == 0) {
						oldUserName = userName;
						userName = JOptionPane.showInputDialog("Enter user name");
						if (userName == null) userName = oldUserName;
						continue;
					} else {
						abortByUser = true;
						break;
					}
				}
			} while (nameCheck == false);

			if (abortByUser == true) return 1;
			
			int max = new Integer(properties.getProperty("search_max"));
			GSSearchEngine.getInstance().setMaxFound(max);
			
			//20090118 North Grid add
			String searchEngineString = properties.getProperty("image_seatch_engine");
			int searchEngine = searchEngineString == null ? 0 : new Integer(searchEngineString);
			if( searchEngine == 0 ){
				GSSearchEngine.getInstance().setUseExternalEngine(true);
			}else{
				GSSearchEngine.getInstance().setUseExternalEngine(false);
			}
			
			//20080715 shimizu wrote
			int searchType = new Integer(properties.getProperty("search_type"));
			GSSearchEngine.getInstance().setSearchType(searchType);
			int textType = new Integer(properties.getProperty("text_type"));
			TextType.setTextType(textType);
			
			this.gsFolderPathString = properties.getProperty("gsFolderPath");
			if (gsFolderPathString == null || gsFolderPathString.equals("")) gsFolderPathString = "./smart_gs/gs/";
			
			this.imageFolderPathString = properties.getProperty("imageFolderPath");
			if (imageFolderPathString == null || imageFolderPathString.equals("")) imageFolderPathString = "./smart_gs/images/";
			
			this.dscFolderPathString = properties.getProperty("dscFolderPath");
			if (dscFolderPathString == null || dscFolderPathString.equals("")) dscFolderPathString = "./smart_gs/images/";
			
			// ADD NorthGrid
			this.smart_exportFolderPathString = properties.getProperty("smart_exportFolderPath");
			//2007/11/20 kazuhiro kobayashi
//			this.nameCorrespondenceFilePathString = properties.getProperty("nameCorrespondenceFilePath");
//			//2007/11/27 kazuhiro kobayshi
			this.defaultGsFilePathString = properties.getProperty("defaultGsFilePath");
			//2007/12/8 kazuhiro kobayshi
			this.RWBackgroundFilePathString = properties.getProperty("RWBackgroundFilePath");
			// 2009/01/23 NorthGrid
			try{
				this.filemode = Integer.parseInt(properties.getProperty("file_mode"));
			}catch(NumberFormatException e){}
			
			this.webdavServerPathString = properties.getProperty("WebDavServerPath");
			this.webdavUserName   = properties.getProperty("WebDavUserName");
			this.webdavPassword   = properties.getProperty("WebDavPassword");
			
			this.browser = properties.getProperty("browser");
			
			this.editor = properties.getProperty("editor");

			this.webdavunlock = properties.getProperty("WebDavUnlock");
			if(webdavunlock == null){
				webdavunlock = "1";
			}

			this.searchImageDictionaryLogic = properties.getProperty("SearchLogic");
			if(searchImageDictionaryLogic == null){
				searchImageDictionaryLogic = "0";
			}
			
			// 2011.02.20 shayashi
			this.firstIDATName = properties.getProperty("firstIDATName");
			if(firstIDATName == null){
				firstIDATName = "Note1";
			}
			this.secondIDATName = properties.getProperty("secondIDATName");
			if(secondIDATName == null){
				secondIDATName = "Note2";
			}
			this.thirdIDATName = properties.getProperty("thirdIDATName");
			if(thirdIDATName == null){
				thirdIDATName = "Note3";
			}
			
			// 2010/04/19
			this.proxyAddress = properties.getProperty("ProxyAddress");
			this.proxyPort    = properties.getProperty("ProxyPort");
			
			String movabilityString = properties.getProperty("markupMovability");
			if (movabilityString == null) {
				this.markupMovability = "false";
			} else {
				this.markupMovability = properties.getProperty("markupMovability");
				boolean markupMovable = new Boolean(this.markupMovability);
				UniSelectedState.getInstance().setMarkupMovability(markupMovable);
			}
			String memoPadColorString = properties.getProperty("memoPadColor");
			if (memoPadColorString == null) {
				this.memoPadColor = "green";
			} else {
				this.memoPadColor = memoPadColorString;
			}
			String markerColorString = properties.getProperty("markerColor");
			if (markerColorString == null) {
				this.markerColor = "yellow";
			} else {
				this.markerColor = markerColorString;
			}
			String makerBreadthString = properties.getProperty("markerBreadth");
			if (makerBreadthString == null) {
				this.markerBreadth = "15";
			} else {
				this.markerBreadth = properties.getProperty("markerBreadth");
			}
			if (new Integer(this.markerBreadth) < 5) {
				this.markerBreadth = "15";
			}
			String bookmarkSizeString = properties.getProperty("bookmarkSize");
			if (bookmarkSizeString == null) {
				this.bookmarkSize = "1.0";
			} else {
				this.bookmarkSize = properties.getProperty("bookmarkSize");
			}
			if (!BookmarkView.properSize(new Double(this.bookmarkSize))) {
				this.bookmarkSize = "1.0";
			}
			String resourceBasketSaveOptionString = properties.getProperty("resourceBasketSaveOption");
			if (resourceBasketSaveOptionString == null) {
				this.resourceBasketSaveOption = "false";
			} else {
				this.resourceBasketSaveOption = properties.getProperty("resourceBasketSaveOption");

			}
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		return 0;
	}
	
	
	public void save() {
		Properties properties = new Properties();
		properties.put("userName", userName);
		int max = GSSearchEngine.getInstance().getMaxFound();
		properties.put("search_max",max+"");

		//20090118 North Grid add
		if( GSSearchEngine.getInstance().isUseExternalEngine() ){
			properties.put("image_seatch_engine","0");
		}else{
			properties.put("image_seatch_engine","1");
		}
		
		int searchType = GSSearchEngine.getInstance().getSearchType();
		properties.put("search_type",searchType+"");
		//20080715 shimizu wrote
	    int textType = TextType.getTextType();
		properties.put("text_type", textType+"");
		//2007/10/7 kazuhiro kobayashi
		if(this.gsFolderPathString!=null){
			properties.put("gsFolderPath", this.gsFolderPathString);
		}
		
		if(this.imageFolderPathString!=null){
			properties.put("imageFolderPath", this.imageFolderPathString);
		}
		
		if(this.dscFolderPathString!=null){
			properties.put("dscFolderPath", this.dscFolderPathString);
		}
		
		if(this.defaultGsFilePathString!=null){
			properties.put("defaultGsFilePath", this.defaultGsFilePathString);
		}
		
		if(this.RWBackgroundFilePathString !=null){
			properties.put("RWBackgroundFilePath", this.RWBackgroundFilePathString);
		}
		
		// 2009/01/23 NorthGrid
		properties.put("file_mode", String.valueOf(this.filemode));
		if(webdavServerPathString != null){
			properties.put("WebDavServerPath", webdavServerPathString);
		}
		if(webdavUserName != null){
			properties.put("WebDavUserName", webdavUserName);
		}
		if(webdavPassword != null){
			properties.put("WebDavPassword", webdavPassword);
		}
		if(this.browser != null){
			properties.put("browser", browser);
		}
		if(this.editor != null){
			properties.put("editor", editor);
		}
		if(this.webdavunlock != null){
			properties.put("WebDavUnlock", webdavunlock);
		}
		if(this.searchImageDictionaryLogic != null){
			properties.put("SearchLogic", searchImageDictionaryLogic);
		}
		// 20100419
		if(proxyAddress != null){
			properties.put("ProxyAddress", proxyAddress);
		}
		if(proxyPort != null){
			properties.put("ProxyPort", proxyPort);
		}
//		2011.02.23 shayashi
		if(firstIDATName != null){
			properties.put("firstIDATName", firstIDATName);
		}
		if(secondIDATName != null){
			properties.put("secondIDATName", secondIDATName);
		}
		if(thirdIDATName != null){
			properties.put("thirdIDATName", thirdIDATName);
		}

		if (markupMovability != null) {
			properties.put("markupMovability", markupMovability);
		}
		if (memoPadColor != null) {
			properties.put("memoPadColor", memoPadColor);
		}
		if (markerColor != null) {
			properties.put("markerColor", markerColor);
		}
		if (markerBreadth != null) {
			properties.put("markerBreadth", markerBreadth);
		}
		if (bookmarkSize != null) {
			properties.put("bookmarkSize", bookmarkSize);
		}
		if (resourceBasketSaveOption != null) {
			properties.put("resourceBasketSaveOption", resourceBasketSaveOption);
		}
		try {
			FileOutputStream outStream = new FileOutputStream(new File(preferenceFile));
			properties.storeToXML(outStream,"no comment");
			//		
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		// 20090907
		

	}
	//2007/10/7 kazuhiro kobayashi
	public String getGsFolderPathString(){
		return this.gsFolderPathString;
	}
	public void setGsFolderPathString(String gsFolderPathString){
		this.gsFolderPathString = gsFolderPathString;
	}
	// ADD NorthGrid
	public String getSmart_exportFolderPathString() {
		return smart_exportFolderPathString;
	}

	public void setSmart_exportFolderPathString(String smart_exportFolderPathString) {
		this.smart_exportFolderPathString = smart_exportFolderPathString;
	}
	
	
	//2007/10/11 kazuhiro kobayashi
	public String getImageFolderPathString() {
		return imageFolderPathString;
	}
	
	//2007/10/11 kazuhiro kobayashi
	public String getImageFolderPathStringInRaw() {
		return imageFolderPathString;
	}

	public void setImageFolderPathString(String imageFolderPathString) {
		
		if(imageFolderPathString != null){
			this.imageFolderPathString = imageFolderPathString ;
		}
	}
	
	public void setDscFolderPathString(String dscFolderPathString) {
		
		if(dscFolderPathString != null){
			this.dscFolderPathString = dscFolderPathString ;
		}
	}

	public String getDscFolderPathString() {
		return dscFolderPathString;
	}

	public String getLineFolderPathString() {
		return imageFolderPathString;
	}

	public void setNameCorrespondencePathString(String nameCorrespondencePathString){
//		if(nameCorrespondencePath!=null){
			this.nameCorrespondenceFilePathString = nameCorrespondencePathString;
//		}
	}
	public String getNameCorrespondencePath(){
		return this.nameCorrespondenceFilePathString;
	}

	public String getDefaultGsFilePathString() {
		return defaultGsFilePathString;
	}
	public void setDefaultGsFilePath(String defaultGsFolePathString) {
		this.defaultGsFilePathString = defaultGsFolePathString;
	}

	//2007/12/8 kazuhiro kobayshi
	public String getRWBackgroundFilePathString() {
		return RWBackgroundFilePathString;
	}

	public void setRWBackgroundFilePathString(String backgroundFilePathString) {
		RWBackgroundFilePathString = backgroundFilePathString;
	}

	// 2009/01/23 NorthGrid
	public int getFilemode() {
		return filemode;
	}

	public void setFilemode(int filemode) {
		this.filemode = filemode;
	}

	public String getWebdavPassword() {
		return webdavPassword;
	}

	public void setWebdavPassword(String webdavPassword) {
		this.webdavPassword = webdavPassword;
	}

	public String getWebdavServerPathString() {
		return webdavServerPathString;
	}

	public void setWebdavServerPathString(String webdavServerPathString) {
		this.webdavServerPathString = webdavServerPathString;
	}

	public String getWebdavUserName() {
		return webdavUserName;
	}

	public void setWebdavUserName(String webdavUserName) {
		this.webdavUserName = webdavUserName;
	}

	public String getBrowser() {
		return browser;
	}

	public void setBrowser(String browser) {
		this.browser = browser;
	}

	public String getEditor() {
		return editor;
	}

	public void setEditor(String editor) {
		this.editor = editor;
	}

	public static String getPreferenceFile() {
		return preferenceFile;
	}

	public static void setPreferenceFile(String preferenceFile) {
		Preference.preferenceFile = preferenceFile;
	}

	public String getWebdavunlock() {
		return webdavunlock;
	}

	public String getSearchImageDictionaryLogic() {
		return searchImageDictionaryLogic;
	}

	public void setSearchImageDictionaryLogic(String searchImageDictionaryLogic) {
		this.searchImageDictionaryLogic = searchImageDictionaryLogic;
	}

	public String getProxyAddress() {
		return proxyAddress;
	}

	public void setProxyAddress(String proxyAddress) {
		this.proxyAddress = proxyAddress;
	}

	public String getProxyPort() {
		return proxyPort;
	}

	public void setProxyPort(String proxyPort) {
		this.proxyPort = proxyPort;
	}

	public void setMarkupMovability(String movability) {
		this.markupMovability = movability;
	}

	public String getMarkupMovability() {
		return markupMovability;
	}

	public void setMemoPadColor(String memoPadColor) {
		this.memoPadColor = memoPadColor;
	}

	public String getMemoPadColor() {
		return memoPadColor;
	}

	public void setMarkerBreadth(String markerBreadth) {
		this.markerBreadth = markerBreadth;
	}

	public String getMarkerBreadth() {
		return markerBreadth;
	}

	public void setMarkerColor(String markerColor) {
		this.markerColor = markerColor;
	}

	public String getMarkerColor() {
		return markerColor;
	}

	public void setBookmarkSize(String bookmarkSize) {
		this.bookmarkSize = bookmarkSize;
	}

	public String getBookmarkSize() {
		return bookmarkSize;
	}

	public void setResourceBasketSaveOption(String resourceBasketSaveOption) {
		this.resourceBasketSaveOption = resourceBasketSaveOption;
	}

	public String getResourceBasketSaveOption() {
		return resourceBasketSaveOption;
	}
}