/* $Id: TextSegment.java 327 2011-08-30 12:59:17Z minao $ */
package smart_gs.logical;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

import javax.swing.JPanel;

import org.w3c.dom.Element;

import reasoning_web.logical.NotMarkupException;
import reasoning_web.logical.inter_face.NoWayToShowException;
import smart_gs.GSConstants;
import smart_gs.logical.visitor.ShowResourceVisitor;
import smart_gs.logical.visitor.Visitor;
import smart_gs.menu.action.SpreadJumpAction;
import smart_gs.menu.action.SpreadOpenAction;
import smart_gs.reasoning_web.logical.GS_RWElement;
import smart_gs.reasoning_web.swingui.elementViewPanelListener;
import smart_gs.smleditor.swingui.GSEditorTextPane;
import smart_gs.smleditor.swingui.GSWysiwygMouseMiniListener;
import smart_gs.util.InConstruction;
import sml_editor.swingui.wysiwyg.WysiwygMouseListener;

public class TextSegment extends GSResource implements Markup {
	
	protected String tagname;
	protected SmartDocument document;
	
	private String timeZone;

	public TextSegment(String tagname,SmartDocument document,int id,
			String uri, String originalURI, String version, String timeZone) {
		//kobayashi
		super();
		this.document = document;
		this.setId(id);
		this.tagname = tagname;
		this.setURIs(uri, originalURI);
		this.setVersion(version);
		this.timeZone = timeZone;
	}
	public TextSegment(String tagname, SmartDocument document, int id) {
		super();
		this.document = document;
		this.setId(id);
		this.tagname = tagname;
		this.setURIs();
	}

	TextSegment(String tagname,int id,String uri, String originalURI, String version){
		super();
		this.tagname = tagname;
		this.setId(id);
		this.setURIs(uri, originalURI);
		this.setVersion(version);
	}
	

	public String getTagName(){
		return this.tagname;
	}
	public SmartDocument getDocument(){
		return this.document;
	}
	@Override
	public JPanel createElementViewPanel() throws NoWayToShowException {
		JPanel panel = new JPanel(new BorderLayout());

		
		String source = null;
		

		if(this.document instanceof IDAT){

		try{
			String originalSource = this.document.getSource();
			if(!(originalSource.indexOf("<xml><html>") == -1 && originalSource.lastIndexOf("</html>") == -1)){
				source = originalSource.substring("<xml><html>".length(),originalSource.lastIndexOf("</html>"));
			}
		}catch(Exception e){
		}
		}else{
			source = this.document.getSource();
			if(!(source.indexOf("<xml><html>") == -1 && source.lastIndexOf("</html></xml>") == -1)){
				source = source.substring("<xml><html>".length(),source.lastIndexOf("</html></xml>"));
			}
		}
		GSEditorTextPane textPane = new GSEditorTextPane(this.document,source);
		textPane.getGSHTMLEditorTextPane().setMouseListener(new GSWysiwygMouseMiniListener(textPane));
		textPane.setMenuMode(true);
		textPane.setSourceMode(false);
		textPane.setEdit(false);
		textPane.updateUI();
		textPane.setAutoscrolls(false);
		textPane.emphasize(this.id+""); 
		textPane.getGSHTMLEditorTextPane().updateText();
		textPane.setFocusable(false);
		panel.add(textPane,BorderLayout.CENTER);
		return panel;
	}
	
	@Override
	public JPanel createElementViewPanel(int width, int height) throws NoWayToShowException {
		JPanel panel = new JPanel(new BorderLayout());
		panel.setPreferredSize(new Dimension(width,height));
		
		String source = null;
		
		if(this.document instanceof IDAT){
		try{
			String originalSource = this.document.getSource();
			if(!(originalSource.indexOf("<xml><html>") == -1 && originalSource.lastIndexOf("</html>") == -1)){
				source = originalSource.substring("<xml><html>".length(),originalSource.lastIndexOf("</html>"));
			}
		}catch(Exception e){
		}
		}else{
			source = this.document.getSource();
			if(!(source.indexOf("<xml><html>") == -1 && source.lastIndexOf("</html></xml>") == -1)){
				source = source.substring("<xml><html>".length(),source.lastIndexOf("</html></xml>"));
			}
		}
		GSEditorTextPane textPane = new GSEditorTextPane(this.document,source);
		textPane.getGSHTMLEditorTextPane().setMouseListener(new GSWysiwygMouseMiniListener(textPane));
		textPane.setMenuMode(true);
		textPane.setSourceMode(false);
		textPane.setEdit(false);
		textPane.updateUI();
		textPane.setAutoscrolls(false);
		textPane.emphasize(Integer.toString(id));
		textPane.getGSHTMLEditorTextPane().updateText();
		textPane.setFocusable(false);
		panel.add(textPane,BorderLayout.CENTER);
		return panel;
	}
	
	public JPanel createElementViewPanelForLocalView() throws NoWayToShowException {
		JPanel panel = new JPanel(new BorderLayout());
		int target_size = GSConstants.ELEMENT_VIEW_PANEL_FOR_LOCAL_VIEW_SIZE;
		
		String source = null;
		
		if(this.document instanceof IDAT){
		try{
			String originalSource = this.document.getSource();
			if(!(originalSource.indexOf("<xml><html>") == -1 && originalSource.lastIndexOf("</html>") == -1)){
				source = originalSource.substring("<xml><html>".length(),originalSource.lastIndexOf("</html>"));
			}
		}catch(Exception e){
		}
		}else{
			source = this.document.getSource();
			if(!(source.indexOf("<xml><html>") == -1 && source.lastIndexOf("</html></xml>") == -1)){
				source = source.substring("<xml><html>".length(),source.lastIndexOf("</html></xml>"));
			}
		}
		GSEditorTextPane textPane = new GSEditorTextPane(this.document,source);
		textPane.setPreferredSize(new Dimension(target_size,target_size));
		textPane.setMenuMode(true);
		textPane.setSourceMode(false);
		textPane.setEdit(false);
		textPane.updateUI();
		textPane.setAutoscrolls(false);
		textPane.emphasize(Integer.toString(id));
		textPane.getGSHTMLEditorTextPane().updateText();
		textPane.setFocusable(false);
		panel.add(textPane,BorderLayout.CENTER);
		(textPane.getGSHTMLEditorTextPane()).addMouseListener(new elementViewPanelListener(panel, this));
		return panel;
	}

	public void setSmartDocument(SmartDocument document){
		this.document = document;
		if (!this.uri.contains(URIObject.getURIWithoutHeader(document))) {
			this.uri += URIObject.SEP2 + URIObject.getURIWithoutHeader(document);
		}
	}
	
	public static TextSegment restore(Element element){
		String tagname = element.getAttribute("tagname");
		String id = element.getAttribute("id");
		String uri = element.getAttribute("uri");
		String originalURI = element.getAttribute("originalURI");
		String version = element.getAttribute(GSResource.VERSION);
		TextSegment segment = new TextSegment(tagname,new Integer(id),uri,originalURI,version);
		return segment;
	}
	
	@Override
	public void accept(Visitor visitor) {
		visitor.visit(this);
	}
	@Override
	public boolean equals(Object obj) {
		if(obj == null){
			return false;
		}
		return this.toString().equals(obj.toString());
	}
	@Override
	public String createURI() {
		return URICreator.createURI(this);
	}
	@Override
	public String getTypeString() {
		return URICreator.TEXT_SEGMENT;
	}
	@Override
	public void jump() {
		SpreadJumpAction.jumpToMarkup(this);
	}
	@Override
	public void openNewWindow() {
		SpreadOpenAction.openMarkup(this);
	}
	@Override
	public String getTimeZone() {
		return this.timeZone;
	}
	@Override
	public void setTimeZone(String timeZone) {
		this.timeZone = timeZone;		
	}
}
