/* $Id: GSExplanatoryNote.java 284 2011-08-03 01:42:08Z minao $ */
package smart_gs.reasoning_web.logical;

import javax.swing.JPanel;

import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import reasoning_web.logical.Connection;
import reasoning_web.logical.ExplanatoryNote;
import reasoning_web.logical.inter_face.NoWayToShowException;
import reasoning_web.logical.inter_face.RWElement;
import smart_gs.GSConstants;
import smart_gs.logical.ConvertGS;
import smart_gs.logical.GSResource;
import smart_gs.logical.TextSegment;
import smart_gs.logical.URIObject;
import smart_gs.logical.visitor.Visitor;
import smart_gs.reasoning_web.URIBearer;
import smart_gs.smleditor.swingui.GSEditorTextPane;
import smart_gs.smleditor.swingui.GSWysiwygDocumentListener;
import smart_gs.smleditor.swingui.GSWysiwygMouseListener;

public class GSExplanatoryNote extends ExplanatoryNote implements GS_RWElement{

	public GSExplanatoryNote(String source, String uri, String originalURI, String version) {
		super(source, uri, originalURI, version);
	}
	public GSExplanatoryNote(String source) {
		super(source);
	}

	
	public GSEditorTextPane createText(){
		String xml = this.getSource();;
		if(xml.startsWith("<xml><html>") && xml.endsWith("</html></xml>")){
			source = xml.substring("<xml><html>".length(),xml.length() - "</html><xml>".length());
		}
		GSEditorTextPane textPane = new GSEditorTextPane(this,source);
		textPane.setMarkup(false);
		textPane.getGSHTMLEditorTextPane().setMouseListener(new GSWysiwygMouseListener(textPane));
		textPane.getGSHTMLEditorTextPane().setDocumentListener(new GSWysiwygDocumentListener(textPane));

		return textPane;
	}
	
	public String getURI() {
		return this.uri;
	}
	public GSResource getTextSegmentByURI(String uri) {
		for(int i=0;i<this.segments.size();i++){
			if(this.segments.get(i).getURI().equals(uri)){
				System.out.println("return segments.get(" + i + ")");
				return this.segments.get(i);
			}
		}
		System.out.println("return null");
		return null;
	}
	public static GSExplanatoryNote restore(Element noteElement) {
		String uri = noteElement.getAttribute("uri");
		String originalURI = noteElement.getAttribute(GSResource.ORIGINAL_URI);
		String version = noteElement.getAttribute(GSResource.VERSION);
		int id = new Integer(noteElement.getAttribute("id"));
		GSExplanatoryNote note = null;
		note = ExpNoteManager.getInstance().getExplanatoryNote(id);
		if(note == null){
			String source = noteElement.getAttribute("source");
			if(!source.startsWith("<xml><html>")){
				try{
					ConvertGS convertGS = new ConvertGS(source);
					source = convertGS.parser();
					if(source.equals("")){
						source = "<xml><html></html></xml>";
					}else{
						source = "<xml><html>" + source + "</html></xml>";
					}
				}catch(Exception e){
					e.printStackTrace();
				}
			}
            String name = noteElement.getAttribute("name");
			note = new GSExplanatoryNote(source,uri,originalURI,version);
			note.setName(name);
			NodeList list = noteElement.getElementsByTagName("segment");
			for(int i=0;i<list.getLength();i++){
				TextSegment segment = TextSegment.restore((Element)list.item(i));
				note.addTextSegment(segment);
				segment.setSmartDocument(note);
			}
		}
	    return note;
	}
	// @Override
	public void accept(Visitor visitor) {
		visitor.visit(this);
	}
}
