/* $Id: ToolBarPanel.java 289 2011-08-03 15:02:08Z ohura $ */
package smart_gs.swingui;

import java.awt.FlowLayout;
import java.awt.GridLayout;

import javax.swing.JPanel;

import smart_gs.swingui.toolbar.DefaultToolBar;
import smart_gs.swingui.toolbar.GSEditorToolBar;
import smart_gs.swingui.toolbar.HistoryToolBar;
import smart_gs.swingui.toolbar.ImageToolBar;
import smart_gs.swingui.toolbar.MoveTreeToolBar;
import smart_gs.swingui.toolbar.UtilityToolBar;
import smart_gs.swingui.toolbar.SearchToolBar;
import sml_editor.swingui.EditorTextPane;
@SuppressWarnings("serial")
public class ToolBarPanel extends JPanel{
	
	private GSEditorToolBar editorToolBar;
	private HistoryToolBar historyToolBar;
	private MoveTreeToolBar moveTreeToolBar;
	private ImageToolBar imageToolBar;

	public ToolBarPanel(AbstractGSWindow parent){
		super(new GridLayout(2,1));

		JPanel panel1 = new JPanel(new FlowLayout(FlowLayout.LEFT));
		panel1.add(new DefaultToolBar());
		imageToolBar = new ImageToolBar(parent);
		panel1.add(imageToolBar);
		panel1.add(new SearchToolBar(parent));
		this.add(panel1);
		
		JPanel panel2 = new JPanel(new FlowLayout(FlowLayout.LEFT));
		panel2.add(new UtilityToolBar(parent));
		historyToolBar = new HistoryToolBar(parent);
		panel2.add(historyToolBar);
		moveTreeToolBar = new MoveTreeToolBar(parent);
		panel2.add(moveTreeToolBar);
		this.add(panel2);
	}

//	public void setEditorTextPane(EditorTextPane textPane){
//		this.validate();
//	}

	public GSEditorToolBar getGSEditorToolBar(){
		return editorToolBar;
	}
	public HistoryToolBar getHistoryToolBar(){
		return historyToolBar;
	}
	public MoveTreeToolBar getMoveTreeToolBar(){
		return moveTreeToolBar;
	}

	public ImageToolBar getImageToolBar() {
		return imageToolBar;
	}
}
