/* $Id: UtilityToolBar.java 299 2011-08-11 14:23:29Z ohura $ */
package smart_gs.swingui.toolbar;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToolBar;

import smart_gs.GSConstants;
import smart_gs.reasoning_web.swingui.ReasoningWebFrame;
import smart_gs.swingui.AbstractGSWindow;
import smart_gs.swingui.LineSegmentsEditingFrame;
import smart_gs.swingui.toolbar.action.LineSegmentsActionListener;
import smart_gs.swingui.toolbar.action.ShowLinesActionListener;

@SuppressWarnings("serial")
public class UtilityToolBar extends JToolBar implements ActionListener{
	private LineSegmentsEditingFrame lineSegmentsEditingFrame; 
	
	public UtilityToolBar(AbstractGSWindow parent) {
		JButton linesegshow = new JButton(new ImageIcon(GSConstants.ICON_PATH+"linesegment.png"));
		linesegshow.addActionListener(new ShowLinesActionListener(parent));
		linesegshow.setToolTipText("Line Segments Non-Edit Mode");
		this.add(linesegshow);
		
		lineSegmentsEditingFrame = LineSegmentsEditingFrame.getInstance(parent);
		JButton linesegeditin = new JButton(new ImageIcon(GSConstants.ICON_PATH+"linesegmentediting2.png"));
		linesegeditin.addActionListener(new LineSegmentsActionListener(parent));
		linesegeditin.setToolTipText("Line Segments Edit Mode");
		this.add(linesegeditin);
		
		JButton rw = new JButton(new ImageIcon(GSConstants.ICON_PATH+"reasoningweb.png"));
		rw.addActionListener(this);
		rw.setToolTipText("Open Resioning Web");
		this.add(rw);
	}

	public void actionPerformed(ActionEvent e) {
		ReasoningWebFrame.getInstance().setVisible(true);
	}
}
