module ProjectsHelper

  def private_or_group_label(project)
    project.is_group ? t('.group.') : t('.private')
  end

  def open_or_member_only_label(project)
    if project.is_group
      project.is_open ? t('.open') : t('.member_only')
    else
      created_by_handle(project) + t('.only')
    end
  end

  def created_by_handle(project)
    if project.created_by_user_id.nil?
      'system'
    else
      User.find(project.created_by_user_id).handle
    end
  end
end
