# -*- coding: utf-8 -*-
class UnreadFlag < ActiveRecord::Base

  def self.create_flags(user_id, ticket_id)
    users = User.where('id <> ?', user_id)

    # チケットを作成したユーザ以外に対し、そのチケットの未読フラグを作成する
    users.each { |user|
      UnreadFlag.create(user_id: user.id, ticket_id: ticket_id)
    }
  end

  def self.remove_flag(user_id, ticket_id)
    UnreadFlag.destroy_all(["user_id = :user_id and ticket_id = :ticket_id", user_id: user_id, ticket_id: ticket_id])
  end
end
