/*
 * Decompiled with CFR 0.152.
 */
package sos.awt;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollBar;
import sos.awt.JImageCanvas;
import sos.io.SOSImageIO;

public class ImageStack
extends JFrame {
    private ArrayList<Image> imageArray = new ArrayList();
    private SOSImageIO imageIO = new SOSImageIO();
    private JImageCanvas jImageCanvasMain;
    private JMenuBar jMenuBarMain;
    private JMenu jMenuFile;
    private JMenuItem jMenuSaveAll;
    private JMenuItem jMenuSaveCurrent;
    private JScrollBar jScrollBar;

    public ImageStack() {
        this.initComponents();
    }

    public void add(Image img) {
        this.imageArray.add(img);
        this.jScrollBar.setMaximum(this.imageArray.size());
    }

    public void remove(int index) {
        if (0 <= index && index < this.imageArray.size()) {
            this.imageArray.remove(index);
            this.jScrollBar.setMaximum(this.imageArray.size());
        }
    }

    public void setCanvasSize(int width, int height) {
        this.jImageCanvasMain.setSize(width, height);
        this.pack();
    }

    private void drawImage() {
        this.jImageCanvasMain.setFullSrc();
        this.jImageCanvasMain.drawImage();
        this.jImageCanvasMain.repaint();
    }

    private void initComponents() {
        this.jImageCanvasMain = new JImageCanvas();
        this.jScrollBar = new JScrollBar();
        this.jMenuBarMain = new JMenuBar();
        this.jMenuFile = new JMenu();
        this.jMenuSaveCurrent = new JMenuItem();
        this.jMenuSaveAll = new JMenuItem();
        this.setDefaultCloseOperation(2);
        this.setTitle("Image stack");
        this.jImageCanvasMain.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent evt) {
                ImageStack.this.jImageCanvasMainComponentResized(evt);
            }
        });
        this.getContentPane().add((Component)this.jImageCanvasMain, "Center");
        this.jScrollBar.setOrientation(0);
        this.jScrollBar.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent evt) {
                ImageStack.this.jScrollBarAdjustmentValueChanged(evt);
            }
        });
        this.getContentPane().add((Component)this.jScrollBar, "South");
        this.jMenuFile.setText("File");
        this.jMenuSaveCurrent.setText("save current image");
        this.jMenuSaveCurrent.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ImageStack.this.jMenuSaveCurrentActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuSaveCurrent);
        this.jMenuSaveAll.setText("save all images");
        this.jMenuSaveAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ImageStack.this.jMenuSaveAllActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuSaveAll);
        this.jMenuBarMain.add(this.jMenuFile);
        this.setJMenuBar(this.jMenuBarMain);
        this.pack();
    }

    private void jMenuSaveAllActionPerformed(ActionEvent evt) {
        File parent = this.imageIO.getSaveDirectory();
        int type = this.imageIO.getFileType();
        for (int i = 0; i < this.imageArray.size(); ++i) {
            BufferedImage img;
            System.out.println("OK" + i);
            try {
                img = (BufferedImage)this.imageArray.get(i);
            }
            catch (ClassCastException e) {
                Image tempImage = this.imageArray.get(i);
                img = new BufferedImage(tempImage.getWidth(null), tempImage.getHeight(null), 2);
                Graphics g = img.getGraphics();
                g.drawImage(tempImage, 0, 0, null);
            }
            File file = new File(parent.getPath() + SOSImageIO.separator + i);
            SOSImageIO.writeImage(file, type, img);
        }
    }

    private void jMenuSaveCurrentActionPerformed(ActionEvent evt) {
        BufferedImage img = (BufferedImage)this.imageArray.get(this.jScrollBar.getValue());
        this.imageIO.writeImage(img);
    }

    private void jImageCanvasMainComponentResized(ComponentEvent evt) {
        this.drawImage();
    }

    private void jScrollBarAdjustmentValueChanged(AdjustmentEvent evt) {
        Image img = this.imageArray.get(this.jScrollBar.getValue());
        this.jImageCanvasMain.setImage(img);
        this.drawImage();
    }
}

