/*
 * Decompiled with CFR 0.152.
 */
package sos.gui;

import java.io.File;
import java.util.ArrayList;
import javax.swing.JComboBox;
import sos.io.SOSFileIO;
import sos.util.ColorVector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JComboColorSets
extends JComboBox {
    public boolean loaded = false;
    private SOSFileIO fileIO = new SOSFileIO();
    private File dataFile;
    private ArrayList<int[][]> RGBSet = new ArrayList();

    public JComboColorSets() {
        this.initComponents();
    }

    public void clear() {
        super.removeAllItems();
        this.RGBSet.clear();
    }

    @Override
    public final void removeItemAt(int index) {
        super.removeItemAt(index);
        this.RGBSet.remove(index);
    }

    public final void addItem(String name, int[][] data) {
        this.addItem(name);
        this.RGBSet.add(data);
    }

    public final int[][] getSelectedRGB() {
        return this.RGBSet.get(this.getSelectedIndex());
    }

    public final int[] getSelectedRGBint() {
        return ColorVector.RGBtoInt(this.getSelectedRGB());
    }

    public void setRGB(int[][] data) {
        this.RGBSet.set(this.getSelectedIndex(), data);
    }

    public void setRGB(int index, int[][] data) {
        this.RGBSet.set(index, data);
    }

    public final int[][] getRGB(int index) {
        return this.RGBSet.get(index);
    }

    public final void loadItem(String path) {
        this.dataFile = new File(path);
        ArrayList<String> args = SOSFileIO.readStrings(this.dataFile);
        if (args == null) {
            this.addItem("n3IHC", new int[][]{{255, 255, 255}, {180, 190, 210}, {180, 160, 160}});
        } else {
            for (int i = 0; i < args.size(); i += 2) {
                String name = args.get(i);
                String[] data = args.get(i + 1).split(" ");
                int[][] currentRGB = new int[data.length][3];
                for (int j = 0; j < data.length; ++j) {
                    String[] rgb = data[j].split(",");
                    for (int k = 0; k < rgb.length; ++k) {
                        currentRGB[j][k] = Integer.parseInt(rgb[k]);
                    }
                }
                this.addItem(name, currentRGB);
            }
        }
        this.loaded = true;
    }

    public final boolean saveItem() {
        String[] args = new String[this.RGBSet.size() * 2];
        for (int i = 0; i < this.RGBSet.size(); ++i) {
            args[i * 2] = (String)this.getItemAt(i);
            int index = i * 2 + 1;
            args[index] = "";
            int[][] data = this.RGBSet.get(i);
            for (int j = 0; j < data.length; ++j) {
                int n = index;
                args[n] = args[n] + data[j][0];
                for (int k = 1; k < data[j].length; ++k) {
                    int n2 = index;
                    args[n2] = args[n2] + "," + data[j][k];
                }
                int n3 = index;
                args[n3] = args[n3] + " ";
            }
        }
        SOSFileIO.writeStrings(this.dataFile, args);
        return true;
    }

    protected ArrayList<int[][]> getRGBSet() {
        return this.RGBSet;
    }

    protected void setRGBSet(ArrayList<int[][]> model) {
        this.RGBSet = model;
    }

    public void copy(JComboColorSets another) {
        another.setModel(this.getModel());
        another.setRGBSet(this.getRGBSet());
    }

    private void initComponents() {
    }
}

