/*
 * Decompiled with CFR 0.152.
 */
package sos.process;

import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;

public class ImagePixelMediator {
    public static Image convertToImage(int[] pixels, int width, int height) {
        MemoryImageSource mis = new MemoryImageSource(width, height, pixels, 0, width);
        return Toolkit.getDefaultToolkit().createImage(mis);
    }

    public static Image convertToImage(byte[] pixels, int width, int height) {
        MemoryImageSource mis = new MemoryImageSource(width, height, null, pixels, 0, width);
        return Toolkit.getDefaultToolkit().createImage(mis);
    }

    public static int[] convertToPixels(Image img) {
        int w = img.getWidth(null);
        int h = img.getHeight(null);
        int[] pixels = new int[w * h];
        PixelGrabber pg = new PixelGrabber(img, 0, 0, w, h, pixels, 0, w);
        try {
            pg.grabPixels();
            return pixels;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int[] convertToPixels(Image img, Rectangle rect) {
        int[] pixels = new int[rect.width * rect.height];
        PixelGrabber pg = new PixelGrabber(img, rect.x, rect.y, rect.width, rect.height, pixels, 0, rect.width);
        try {
            pg.grabPixels();
            return pixels;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Image setAlpha(Image img, double transparency) {
        int alpha = (int)(255.0 * transparency) << 24;
        int[] pixels = ImagePixelMediator.convertToPixels(img);
        int[] newPixels = new int[pixels.length];
        for (int i = 0; i < pixels.length; ++i) {
            int value = pixels[i] & 0xFFFFFF;
            newPixels[i] = value + alpha;
        }
        return ImagePixelMediator.convertToImage(newPixels, img.getWidth(null), img.getHeight(null));
    }
}

